---
description: Build nightly ZIP of Kodi addon and deploy to server via SCP
---

# /deploy

Build a nightly ZIP of the addon and upload it to the server.

## When to Use
- When you want to create a nightly build and deploy it
- After finishing a feature or fix

## Configuration

```
ADDON_ID: plugin.video.milionar
ADDON_ROOT: <from workspace URI>
HOST: hosting.pilsfree.net
USER: chudy
REMOTE_DIR: /home/chudy/public_html/kodi/
SSH_AUTH: SSH key (system keychain)
```

## Procedure

// turbo-all

### 1. Read Current Version
Read `addon.xml` and extract the current `version="X.Y.Z"` value.

### 2. Set Nightly Version
- Generate nightly version string: `X.Y.Z+nightly.YYYYMMDD.HHMM` (use current local date/time)
- Update `version` attribute in `addon.xml` to the nightly version
- Example: `1.0.6` -> `1.0.6+nightly.20260212.2316`

### 3. Build ZIP
Create the ZIP with correct Kodi structure. The ZIP MUST contain a root folder named `plugin.video.milionar/`.

```bash
cd "{ADDON_ROOT}/.." && zip -r "/tmp/plugin.video.milionar-nightly-{YYYY-MM-DD}_{HHMM}.zip" "plugin.video.milionar/" \
  -x "plugin.video.milionar/.agent/*" \
  -x "plugin.video.milionar/.gemini/*" \
  -x "plugin.video.milionar/docs/*" \
  -x "plugin.video.milionar/__pycache__/*" \
  -x "plugin.video.milionar/wcs/__pycache__/*" \
  -x "plugin.video.milionar/wcs/*/__pycache__/*" \
  -x "plugin.video.milionar/.git/*" \
  -x "plugin.video.milionar/.gitignore" \
  -x "*.pyc" \
  -x "*.pyo" \
  -x ".DS_Store"
```

> [!IMPORTANT]
> The ZIP **must** have `plugin.video.milionar/` as root folder inside. Kodi requires this structure for install from ZIP.

### 4. Upload via SCP
```bash
scp "/tmp/plugin.video.milionar-nightly-{YYYY-MM-DD}_{HHMM}.zip" chudy@hosting.pilsfree.net:/home/chudy/public_html/kodi/
```

### 5. Build and Upload Agent ZIP
Package `.agent/` and `docs/` into a separate ZIP and upload to server.

```bash
cd "{ADDON_ROOT}" && zip -r "/tmp/milionar-agent-{YYYY-MM-DD}_{HHMM}.zip" ".agent/" "docs/" \
  -x "*.pyc" \
  -x "*.pyo" \
  -x ".DS_Store" \
  -x "*__pycache__*"
```

```bash
scp "/tmp/milionar-agent-{YYYY-MM-DD}_{HHMM}.zip" chudy@hosting.pilsfree.net:/home/chudy/public_html/kodi/
```

### 6. Verify Upload
```bash
ssh chudy@hosting.pilsfree.net "ls -lh /home/chudy/public_html/kodi/plugin.video.milionar-nightly-{YYYY-MM-DD}_{HHMM}.zip /home/chudy/public_html/kodi/milionar-agent-{YYYY-MM-DD}_{HHMM}.zip"
```

### 7. Report
Print:
- Nightly version set in addon.xml
- Addon ZIP filename and size
- Agent ZIP filename and size
- Remote URLs for both ZIPs: `http://hosting.pilsfree.net/chudy/kodi/{FILENAME}`

> [!CAUTION]
> Do NOT revert the version in addon.xml. The nightly version stays.

## ZIP Structure Requirements (Kodi)
- Root folder inside addon ZIP = addon ID (`plugin.video.milionar/`)
- Must contain `addon.xml` at root level inside the folder
- No `__pycache__/`, `.agent/`, `docs/`, `.git/` in the addon ZIP
- No `.pyc`, `.pyo`, `.DS_Store` files

## What It Does
1. **Version bump** -- sets nightly version in addon.xml
2. **Addon ZIP** -- packages the addon with correct Kodi structure
3. **Agent ZIP** -- packages `.agent/` and `docs/` into `milionar-agent-{date}.zip`
4. **SCP** -- uploads both ZIPs to server
5. **Verify** -- confirms both files exist on server