---
description: Debug session -- add diagnostic logs, analyze Kodi log, cleanup
---

# /debug

Syntax: `/debug create|log|end [component/problem description]`

Uses skill `debug` as authority for all procedures.

## Modes

### `/debug create [problem description]`

Add diagnostic `[DEBUG]` logs to Python code.

1. Load skill `debug` -- Phase 1 (Create)
2. Analyze the problem -- identify relevant files and functions
3. Add `[DEBUG]` logs at strategic locations (per skill rules)
4. Report what was added and where
5. Instruct user to restart Kodi and reproduce the problem

### `/debug log [what to look for]`

Read and analyze Kodi log autonomously.

1. Load skill `debug` -- Phase 2 (Log Analysis)
2. Grep kodi.log for `[DEBUG]`, `ERROR`, `WARNING`, `Traceback`
3. Iterate -- try different search terms until root cause is found
4. Fallback -- read last 200-300 lines if grep yields nothing
5. Present findings and propose fix
6. If more data needed -- go back to `/debug create` with targeted logs

### `/debug end`

Remove all temporary debug output.

1. Load skill `debug` -- Phase 3 (Cleanup)
2. Grep all `.py` files for `[DEBUG]` and `# DEBUG`
3. Remove all temporary debug lines
4. Verify no `[DEBUG]` lines remain
5. Report files cleaned

## Rules

- Always use skill `debug` for format and procedures
- Agent decides autonomously what to search in the log
- Never remove production logs (only `[DEBUG]` prefixed lines)
- `/debug end` is mandatory after issue is resolved
