---
description: Create a new rule, skill or workflow as needed
---

# /create

Syntax: see `workflow-syntax.md` -- scope: type (rule/skill/workflow), `/do` = create without asking

Meta-tool for creating agent configuration.
Use skill `config-creator` and follow `config-standards`.

## Procedure

### 1. Determine What User Needs
- A) Rule -- constraint, standard, checklist
- B) Skill -- expert role, deep knowledge
- C) Workflow -- slash command, procedure
- D) Combination -- decide by purpose
- E) Custom description

### 2. Clarify Purpose
- Name
- Purpose (1 sentence)
- Trigger -- when it activates

### 3. Decide What to Create
- Constraint/standard/checklist -> Rule
- Expert role/knowledge -> Skill
- Slash command/procedure -> Workflow
- Combination as needed

### 4. Propose Structure
Table: Type | File | Purpose

### 5. Without `/do`: Wait for Approval

### 6. Create Files
Use skill `config-creator`, follow templates.

### 7. Confirm Creation
Type, file, how to use.

## Rules
- Check existing configuration (no duplicates)
- Without `/do`: User must approve the proposal
