---
description: Audit codebase -- finds issues, duplicates, inefficiencies and refactoring suggestions
---

# /audit

Syntax: see `workflow-syntax.md` -- scope: Python/XML/component, `/fix` = audit + fix

## Modes
- `/audit` -- entire codebase
- `/audit Python` or `/audit XML` -- specific technology only
- `/audit [component]` -- specific part
- `/audit config` -- audit `.agent/` configuration (see skill `config-auditor`)

## Check Against
1. Rules in `.agent/rules/`
2. Skill `kodi-researcher` for best practices
3. Skill `config-auditor` for `.agent/` configuration review
4. Reference: `.agent/skills/config-auditor/resources/agent-config-spec.md` for agent config spec

## Finding Categories
- DUPLICATE -- duplicated code (DRY violation)
- INEFFICIENCY -- inefficient solution
- BUG -- potential bug
- REFACTOR -- refactoring suggestion
- COMPATIBILITY -- compatibility issue
- STRUCTURE -- project structure violation
- CONFIG -- mismatch with official agent config specification
- LANGUAGE -- non-English text in `.agent/` config files (rules, skills, workflows must be in English for optimal LLM comprehension)

## Severity
- CRITICAL -- must fix (bug, security)
- WARNING -- should fix (inefficiency, duplication)
- INFO -- improvement suggestion

## Procedure
1. Analyze scope (entire codebase / technology / part)
2. Scan `.agent/rules/` and `.agent/skills/` -- identify ALL technologies in the project
3. Web research for EACH area found (Kodi, Python, XML skinning, other)
4. Use skills: `kodi-researcher`, `config-auditor`
5. Go through files systematically
6. **Check `.agent/` files for non-English content** -- flag as LANGUAGE finding
7. Record findings in `docs/audits/[XXX]-[name].md`
8. Create summary `docs/audits/YYYY-MM-DD-summary.md`

## Agent config audit specifics
When running `/audit config` additionally check:
- Skills: YAML contains only `name` + `description` (NO `trigger:` field -- keywords go in description)
- Skills: description has "Use when..." pattern with keywords for discovery
- Skills: descriptions complement each other, not conflict
- Rules: `trigger:` field in YAML is VALID -- Antigravity stores the UI-selected activation mode here; do NOT flag as error
- Rules: max 12K characters, valid `@filename` references
- Workflows: max 12K characters, valid slash command pattern

## Finding Format
```
# Audit: [Name]
## Type: [DUPLICATE/BUG/CONFIG/...]
## Severity: [CRITICAL/WARNING/INFO]
## Created: [YYYY-MM-DD HH:mm]

## Problem
[description]

## Where
- [file](file:///path) -- lines X-Y

## Why It's a Problem
[impact]

## Recommended Solution
[suggestion without implementation]
```

## Rules
- Do not suggest solutions you haven't tested
- Reference existing patterns
- Use `kodi-researcher` for verification
