---
name: playht-tts
description: >
  Use this skill when integrating PlayHT TTS API for text-to-speech,
  voice cloning, conversational dialogue synthesis, or streaming audio.
  Covers REST/WebSocket API, Python urllib integration, models, and voices.
---

# PlayHT TTS Skill

You are an expert at integrating PlayHT TTS API into Python applications.

## Overview

PlayHT provides ultra-realistic text-to-speech with conversational AI:
- **900+ voices** -- 140+ languages, various styles
- **Play3.0** -- multilingual streaming model
- **PlayDialog** -- conversational dialogue, context-aware prosody
- **Voice cloning** -- custom AI voice replicas
- **SSML support** -- pauses, tempo, intonation
- **WebSocket + HTTP streaming** -- real-time audio

## Current Models

| Model | Use Case | Languages | Notes |
|-------|----------|-----------|-------|
| `Play3.0` | General TTS, streaming | Multilingual | Default streaming model |
| `Play3.0-mini` | Lowest latency | Multilingual | Fastest, up to 20K chars |
| `PlayDialog` | Conversational | EN + multi | Context-aware prosody, emotion |
| `PlayDialog-turbo` | Fast dialogue | EN | Powered by Groq silicon |

> [!IMPORTANT]
> `Play3.0-mini` for lowest latency.
> `PlayDialog` for most natural conversational speech.

## API Base

```
https://api.play.ht/api/v2/
```

Authentication:
- `Authorization: Bearer $PLAYHT_API_KEY`
- `X-USER-ID: $PLAYHT_USER_ID`

## Key Endpoints

| Endpoint | Method | Purpose |
|----------|--------|---------|
| `/api/v2/tts/stream` | POST | HTTP streaming TTS |
| `wss://api.play.ht/...` | WS | WebSocket real-time TTS |
| `/api/v2/voices` | GET | List prebuilt voices |
| `/api/v2/batch` | POST | Batch TTS job |

## Quick Start (Python)

```python
import json
import urllib.request

payload = json.dumps({
    'text': text,
    'voice': 'en-US-MichaelNeural',
    'output_format': 'mp3',
    'voice_engine': 'Play3.0-mini',
    'sample_rate': 24000
}).encode('utf-8')

req = urllib.request.Request(
    'https://api.play.ht/api/v2/tts/stream',
    data=payload,
    headers={
        'Authorization': f'Bearer {api_key}',
        'X-USER-ID': user_id,
        'Content-Type': 'application/json',
        'Accept': 'audio/mpeg'
    }
)

with urllib.request.urlopen(req) as resp:
    audio_data = resp.read()
    with open(output_path, 'wb') as f:
        f.write(audio_data)
```

## Output Formats

- `mp3`
- `wav`
- `mulaw`
- `flac`
- `ogg`
- Sample rates: 8K, 16K, 24K, 44.1K, 48K Hz

## API Docs

- [Quickstart](https://docs.play.ht/reference/api-getting-started)
- [Models](https://docs.play.ht/reference/models)
- [HTTP Streaming](https://docs.play.ht/reference/api-generate-tts-audio-stream)
- [WebSocket API](https://docs.play.ht/reference/playht-tts-websocket-api)
- [Prebuilt Voices](https://docs.play.ht/reference/list-of-prebuilt-voices)

## Related Skills
- `ai-api` -- AI integration patterns (Python, TTS)
- `tts-voice-instructor` -- voice instruction engineering (OpenAI TTS)
