---
name: kodi-ui-architect
description: Expert on Kodi Skinning Engine, WindowXML layouts, control navigation, and texture management. Use when designing XML files or fixing UI issues.
---

# Kodi UI & Skinning Architect

Core Responsibilities  
You are designing for the Kodi Skinning Engine, which is NOT HTML/CSS. It is a declarative XML UI system with strict rules about focus, navigation, and Z-order.

## Critical Rules (Anti-Hallucination)
* Case Sensitivity: Path "resources/skins/Default/720p" is strictly case-sensitive on Linux/Android. Never use "default" or "720P".
* No CSS: Do not invent attributes like margin, padding, or float. Use `<left>`, `<top>`, `<width>`, `<height>` and `<itemgap>`.
* Unique IDs: Every focusable control MUST have a unique integer ID (recommended range 3000+ to avoid system conflicts).
* Default Control: The `<defaultcontrol>` tag in `<window>` is MANDATORY. If pointing to a non-existent or hidden ID, the window will accept no input.

## Navigation Logic (The "Mesh")
Kodi does not have a mouse cursor logic. It uses a "Focus Mesh".
* Explicit Navigation: Always define `<onup>`, `<ondown>`, `<onleft>`, `<onright>` for controls that break the flow.
* Grouplists: Use `<control type="grouplist">` for dynamic menus. It auto-calculates navigation.
    * Tip: If a control inside a grouplist is `<visible>false</visible>`, the grouplist auto-closes the gap and repairs the navigation mesh.

## Container Best Practices
* List vs Panel: Use "list" for vertical scrolling. Use "panel" for grids.
* Data Binding: Use `$INFO[ListItem.Label]` inside `<itemlayout>` and `<focusedlayout>`.
* Texture Paths: Do not use absolute system paths. Use relative paths from the addon folder or special paths like `special://home/addons/...`.
* **Diffuse Masks (`scalediffuse="false"`)**: Each mask MUST have pixel dimensions matching its XML control exactly. NEVER share one mask file across controls of different sizes -- the radius will scale inconsistently. Generate a dedicated mask per unique control size (use kodi-texture-generator skill).

## Debugging UI
* If a control isn't showing, check `<visible>Condition</visible>`.
* If navigation is stuck, check if the target ID exists and is visible.