---
name: kodi-fonts
description: >
  Complete overview of all fonts available in Kodi Estuary skin.
  Use when working with XML layouts, selecting fonts for text, or choosing font sizes.
  Covers font selection, text sizing, Estuary font IDs, and typography in Kodi XML.
---

# Kodi Estuary Skin - Complete Font Overview

**IMPORTANT:** Kodi addon dialogs CANNOT use custom fonts. Fonts are always loaded from the active skin (Estuary).

## Basic Information

- **Main font:** `NotoSans-Regular.ttf`
- **Clock:** `Roboto-Thin.ttf`
- **Monospace:** `NotoMono-Regular.ttf`
- **Default font:** `font13` (30px) - Kodi uses this if specified font doesn't exist

---

## COMPLETE FONT LIST

### Standard Fonts (NotoSans-Regular, style: lighten)

| Font ID | Size (px) | Description |
|---------|----------|-------------|
| `font10` | 23 | Smallest text, metadata |
| `font12` | 25 | Small text, descriptions |
| `font13` | 30 | **DEFAULT** - regular text |
| `font14` | 33 | Slightly larger text |
| `font27` | 27 | Medium text |
| `font32` | 32 | Larger text |
| `font37` | 37 | Large headings |
| `font45` | 45 | Very large text |
| `font60` | 60 | Extra large text |

### Narrow Fonts (tighter line spacing, linespacing: 0.8)

| Font ID | Size (px) | Description |
|---------|----------|-------------|
| `font23_narrow` | 23 | Narrow spacing for small text |
| `font25_narrow` | 25 | Narrow spacing for descriptions |
| `font27_narrow` | 27 | Narrow spacing medium |

### Title Fonts (NotoSans-Regular, style: **bold**)

| Font ID | Size (px) | Description |
|---------|----------|-------------|
| `font_flag` | 18 | Smallest bold (for flags) |
| `font20_title` | 20 | Small bold title |
| `font25_title` | 25 | Medium bold title |
| `font30_title` | 30 | Bold like font13 |
| `font32_title` | 32 | Larger bold title |
| `font36_title` | 36 | Large bold title |
| `font40_title` | 40 | Very large bold |
| `font45_title` | 45 | Extra large bold |
| `font52_title` | 52 | Huge bold |
| `font_MainMenu` | 60 | Main menu, bold |

### Special Fonts

| Font ID | File | Size | Description |
|---------|------|------|-------------|
| `font_clock` | Roboto-Thin.ttf | 70 | Clock |
| `WeatherTemp` | NotoSans-Regular | 120 | Temperature (aspect 0.85) |
| `Mono26` | NotoMono-Regular.ttf | 26 | Monospace font |

---

## Size Overview (smallest to largest)

```
font_flag         (18px bold)    - smallest bold
font20_title      (20px bold)    - small bold
font10            (23px)         - smallest regular
font23_narrow     (23px narrow)  - narrow spacing
font12            (25px)         - small text
font25_narrow     (25px narrow)  - narrow spacing
font25_title      (25px bold)    - medium bold
font27            (27px)         - medium text
font27_narrow     (27px narrow)  - narrow spacing
font13            (30px)         - DEFAULT
font30_title      (30px bold)    - bold like default
font32            (32px)         - larger text
font32_title      (32px bold)    - larger bold
font14            (33px)         - slightly larger
font36_title      (36px bold)    - large bold
font37            (37px)         - large headings
font40_title      (40px bold)    - very large bold
font45            (45px)         - very large text
font45_title      (45px bold)    - extra large bold
font52_title      (52px bold)    - huge bold
font60            (60px)         - extra large
font_MainMenu     (60px bold)    - main menu
font_clock        (70px thin)    - clock
WeatherTemp       (120px bold)   - temperature
```

---

## Recommendations for Addon Dialogs

### Series/Movie Titles
```xml
<font>font37</font>       <!-- 37px regular -->
<font>font30_title</font> <!-- 30px bold -->
```

### Regular Text
```xml
<font>font13</font>       <!-- 30px default -->
<font>font14</font>       <!-- 33px slightly larger -->
```

### Metadata, SxxExx, Small Text
```xml
<font>font10</font>       <!-- 23px smallest -->
<font>font12</font>       <!-- 25px small -->
```

### Bold Headings
```xml
<font>font25_title</font> <!-- 25px bold -->
<font>font32_title</font> <!-- 32px bold -->
<font>font36_title</font> <!-- 36px bold -->
```

---

*Source: github.com/xbmc/xbmc/blob/master/addons/skin.estuary/xml/Font.xml*
