---
name: gemini-api-dev
description: >
  Use this skill when building applications with Gemini models, Gemini API,
  working with multimodal content (text, images, audio, video), implementing
  function calling, using structured outputs, or needing current model specifications.
  Covers Python SDK (google-genai), REST API, model selection, and API capabilities.
---

# Gemini API Development Skill

## Overview

The Gemini API provides access to Google's most advanced AI models. Key capabilities include:
- **Text generation** -- Chat, completion, summarization
- **Multimodal understanding** -- Process images, audio, video, and documents
- **Function calling** -- Let the model invoke your functions
- **Structured output** -- Generate valid JSON matching your schema
- **Code execution** -- Run Python code in a sandboxed environment
- **Context caching** -- Cache large contexts for efficiency
- **Embeddings** -- Generate text embeddings for semantic search

## Current Gemini Models

- `gemini-3-pro-preview`: 1M tokens, complex reasoning, coding, research
- `gemini-3-flash-preview`: 1M tokens, fast, balanced performance, multimodal
- `gemini-3-pro-image-preview`: 65k / 32k tokens, image generation and editing

### Free Tier (prototyping -- no cost)
- `gemini-2.5-pro`: free for low-volume, strong reasoning
- `gemini-2.5-flash`: free, low latency, great for real-time voice agents
- `gemini-2.5-flash-lite`: free, lightest, cheapest

> [!TIP]
> Use **Gemini 2.5 free tier** for prototyping and development -- zero cost.
> Switch to Gemini 3 for production or when you need latest capabilities.

> [!IMPORTANT]
> Models `gemini-2.0-*` and `gemini-1.5-*` are legacy and deprecated. Use Gemini 3 or 2.5 models above.

## Python SDK

```bash
pip install google-genai
```

> [!WARNING]
> Legacy SDK `google-generativeai` (Python) is deprecated. Migrate to `google-genai` urgently.

## Quick Start (Python)

```python
from google import genai

client = genai.Client()
response = client.models.generate_content(
    model="gemini-3-flash-preview",
    contents="Explain quantum computing"
)
print(response.text)
```

> [!NOTE]
> In Kodi addons, `google-genai` SDK may not be available (no pip).
> Use direct REST API calls via `urllib.request` instead.

### REST API (urllib -- for Kodi)

```python
import json
import urllib.request

payload = json.dumps({
    'contents': [{'parts': [{'text': user_message}]}]
}).encode('utf-8')

url = f'https://generativelanguage.googleapis.com/v1beta/models/gemini-3-flash-preview:generateContent?key={api_key}'
req = urllib.request.Request(url, data=payload,
    headers={'Content-Type': 'application/json'})

with urllib.request.urlopen(req) as resp:
    data = json.loads(resp.read().decode('utf-8'))
    answer = data['candidates'][0]['content']['parts'][0]['text']
```

## API spec (source of truth)

**Always use the latest REST API discovery spec as the source of truth for API definitions:**

- **v1beta** (default): `https://generativelanguage.googleapis.com/$discovery/rest?version=v1beta`
- **v1**: `https://generativelanguage.googleapis.com/$discovery/rest?version=v1`

When in doubt, use v1beta.

## How to use the Gemini API

**llms.txt URL**: `https://ai.google.dev/gemini-api/docs/llms.txt`

### Key Documentation Pages

- [Models](https://ai.google.dev/gemini-api/docs/models.md.txt)
- [Function calling](https://ai.google.dev/gemini-api/docs/function-calling.md.txt)
- [Structured outputs](https://ai.google.dev/gemini-api/docs/structured-output.md.txt)
- [Text generation](https://ai.google.dev/gemini-api/docs/text-generation.md.txt)
- [Image understanding](https://ai.google.dev/gemini-api/docs/image-understanding.md.txt)
- [Embeddings](https://ai.google.dev/gemini-api/docs/embeddings.md.txt)
- [SDK migration guide](https://ai.google.dev/gemini-api/docs/migrate.md.txt)

## Related Skills
- `ai-api` -- general AI integration patterns (Python, streaming, tools, agent loops)
- `system-prompt-master` -- prompt engineering
