---
name: fish-audio-tts
description: >
  Use this skill when integrating Fish Audio TTS API for text-to-speech,
  voice cloning, or multilingual speech synthesis.
  Covers REST/WebSocket API, Python urllib integration.
---

# Fish Audio TTS Skill

You are an expert at integrating Fish Audio TTS API into Python applications.

## Overview

Fish Audio provides studio-grade TTS with emotion control:
- **S1 model** -- natural, emotionally rich speech
- **Voice cloning** -- 15-second audio clip, 99% accuracy
- **8+ languages** -- multilingual with emotion markers
- **WebSocket** -- real-time streaming
- **REST API** -- simple integration

## Current Models

| Model | Quality | Notes |
|-------|---------|-------|
| `s1` | Studio-grade | Emotion control, multilingual |
| `fish-speech-1.5` | High | Top-ranked multilingual (TTS-Arena2 #1) |

> [!IMPORTANT]
> Fish Audio rebranded from Fish Speech in December 2025.
> Model `s1` is the current flagship.

## API Base

```
https://api.fish.audio/
```

Authentication: `Authorization: Bearer $FISH_AUDIO_API_KEY`

## Key Endpoints

| Endpoint | Method | Purpose |
|----------|--------|---------|
| `/v1/tts` | POST | Generate speech (returns audio) |
| `/v1/models` | GET | List voice models |
| `/model` | POST | Create voice model (clone) |
| `wss://api.fish.audio/v1/tts/live` | WS | Real-time WebSocket |

## Quick Start (Python)

```python
import json
import urllib.request

payload = json.dumps({
    'text': text,
    'reference_id': 'voice-model-id',
    'format': 'mp3',
    'mp3_bitrate': 128
}).encode('utf-8')

req = urllib.request.Request(
    'https://api.fish.audio/v1/tts',
    data=payload,
    headers={
        'Authorization': f'Bearer {api_key}',
        'Content-Type': 'application/json'
    }
)

with urllib.request.urlopen(req) as resp:
    audio_data = resp.read()
    with open(output_path, 'wb') as f:
        f.write(audio_data)
```

## Emotion Markers

Fish Audio supports inline emotion markers in text:
```
[happy] Hello! [sad] I miss you. [angry] Stop it!
```

## Output Formats

- `mp3` (configurable bitrate)
- `opus`
- `wav`
- `pcm`

## API Docs

- [API Reference](https://docs.fish.audio/api-reference)
- [Text-to-Speech](https://docs.fish.audio/text-to-speech)
- [Voice Models](https://docs.fish.audio/voice-models)
- [WebSocket Streaming](https://docs.fish.audio/websocket)

## Related Skills
- `ai-api` -- AI integration patterns (Python, TTS)
- `tts-voice-instructor` -- voice instruction engineering (OpenAI TTS)
