---
name: config-creator
description: >
  Expert creation of agent configuration -- rules, skills, workflows.
  Use when creating new rules, skills, or workflows in .agent/ directory.
---

# Config Creator

You are an expert at creating `.agent/` configurations. Perfect structure, clear instructions, no redundancy.

## Reference
Follow the official Antigravity Agent specification: `.agent/skills/config-auditor/resources/agent-config-spec.md`

## Types

### Rule (`.agent/rules/[name].md`)
- Plain markdown file with optional YAML frontmatter
- Activation mode set via **UI**: Always On, Manual, Model Decision, Glob
- `trigger:` field in YAML is VALID -- Antigravity persists the UI-selected activation mode here (e.g. `trigger: model_decision`)
- `description:` field in YAML is VALID -- used as activation hint for "Model Decision" mode
- Max 12,000 characters
- Supports `@filename` references to other files
- Clear, actionable instructions
- No vague formulations
- CAUTION blocks for critical rules

### Skill (`.agent/skills/[name]/SKILL.md`)
```yaml
---
name: skill-name
description: >
  What the skill does and when to use it.
  Use when [specific activation context]. Include keywords for agent discovery.
---
```
- **YAML frontmatter**: only `name` + `description` (NO `trigger:` field)
- **Description**: 3rd person, "Use when..." pattern, specific keywords for discovery
- **Progressive disclosure**: agent reads only `description` initially, full SKILL.md on activation
- Role description in first person ("You are...")
- Clear principles and rules
- Optional: `scripts/`, `examples/`, `resources/` subdirectories
- Checklist at the end

### Workflow (`.agent/workflows/[name].md`)
```yaml
---
description: Short description of the workflow
---
```
- Max 12,000 characters
- Invoked via `/workflow-name` slash command
- Numbered steps
- Clear actions, no ambiguity
- Modifiers (`/do`, `/explain`)

## Before creation
1. Check if similar configuration already exists
2. Check for description overlaps with existing skills
3. Follow the style of existing files
4. Verify all references are valid

## Language and formatting
- **Rules and Skills** -- MUST be written in **English** (LLMs understand EN instructions better) and **without emojis**
- **Workflows** -- can be in Czech

## Content efficiency

> [!CAUTION]
> **NO markdown tables in config files!**
> Tables waste tokens and add zero value for LLM comprehension.
> LLMs understand plain text and bullet points perfectly.

- Use **plain text**, **bullet points**, and **headers** -- never ASCII/markdown tables
- Keep instructions short and direct -- no decorative formatting
- One concept per line -- no multi-column layouts
- If you can say it in a sentence, don't make it a table

## Quality checklist
- [ ] YAML header complete (name + description for skills, description for workflows)
- [ ] Description clear, with "Use when..." pattern and keywords for agent discovery
- [ ] Instructions clear and actionable
- [ ] No placeholders or TODOs
- [ ] Consistent with existing configs
- [ ] No `trigger:` field in **skills** (discovery keywords belong in description, not trigger)
