# Antigravity Agent Configuration Specification

Official reference for `.agent/` configuration structure. Use this as the source of truth when auditing or creating rules, skills, and workflows.

## Architecture

```
.agent/                       # Workspace configuration
├── rules/                    # Agent behavior constraints
│   └── *.md                  # Markdown files with instructions
├── skills/                   # Extended capabilities
│   └── <skill>/              # Folder per skill
│       ├── SKILL.md          # Required -- instructions + frontmatter
│       ├── scripts/          # Helper scripts (optional)
│       ├── examples/         # Reference implementations (optional)
│       └── resources/        # Templates, assets (optional)
└── workflows/                # Step-by-step procedures
    └── *.md                  # Markdown with steps + frontmatter
```

---

## 1. Rules

### What they are
Markdown files defining constraints and behavior. Persistent context at prompt level.

### Location

| Scope | Path |
|-------|------|
| Global | `~/.gemini/GEMINI.md` |
| Workspace | `.agent/rules/*.md` |

### Activation modes

| Mode | Description |
|------|-------------|
| **Always On** | Rule is always active |
| **Manual** | Activation via `@rule` in agent input |
| **Model Decision** | Agent decides based on rule description |
| **Glob** | Activation by file glob pattern (`*.py`, `src/**/*.xml`) |

### Format

```markdown
---
trigger: model_decision
description: When to activate this rule -- keywords for agent discovery.
---

# Rule Name

Markdown content with instructions for the agent.
```

> [!NOTE]
> The official spec does NOT define frontmatter for rules -- activation is set in UI.
> Our `trigger` and `description` fields are non-standard but harmless (agent ignores them).
> They serve as self-documentation.

### Limits
- **Max 12,000 characters** per rule file
- `@filename` -- reference to other files (relative and absolute paths)

---

## 2. Skills

### What they are
Reusable knowledge packages extending agent capabilities. Folder with `SKILL.md` + optional resources.

### Open Standard
Skills are an open standard (originally Anthropic, adopted by Google). Cross-tool portable.

### Location

| Scope | Path |
|-------|------|
| Workspace | `.agent/skills/<skill-folder>/` |
| Global | `~/.gemini/antigravity/skills/<skill-folder>/` |

### SKILL.md format

```markdown
---
name: skill-name
description: >
  What the skill does and when to use it.
  Use when [specific context]. Include keywords for agent discovery.
---

# Skill Name

Detailed instructions, conventions, patterns.
```

| Field | Required | Description |
|-------|----------|-------------|
| `name` | No | Unique identifier (default = folder name) |
| `description` | **Yes** | Description + trigger -- agent decides based on this |

> [!IMPORTANT]
> **NO `trigger:` field** in skill frontmatter. Discovery keywords go in `description`.

### Progressive Disclosure Pattern

1. **Discovery** -- agent sees names + descriptions (conversation start)
2. **Activation** -- if relevant, reads full SKILL.md
3. **Execution** -- agent follows instructions

### Folder structure

```
.agent/skills/<skill>/
├── SKILL.md       # Required
├── scripts/       # Helper scripts
├── examples/      # Reference implementations
└── resources/     # Templates, assets
```

### Best Practices
- **One skill = one thing** -- don't overload with universal content
- **Clear description** -- agent decides by description, bad description = skill not used
- **Scripts with `--help`** -- agent runs `--help` instead of reading full code
- **Decision trees** -- for complex skills add decision trees

---

## 3. Workflows

### What they are
Structured step sequences at trajectory level. Invoked via slash commands.

### Difference from Rules
- **Rules** = persistent context (WHAT to follow)
- **Workflows** = step sequences (HOW to do it)

### Format

```markdown
---
description: Short workflow description
---

# /workflow-name

## Steps

### 1. First step
Instructions...

### 2. Second step
Instructions...
```

### Properties
- **Invocation**: `/workflow-name` in agent input
- **Nesting**: workflow can call other workflows
- **Limit**: 12,000 characters per workflow
- **Agent-Generated**: agent can create workflow from conversation history
- **Location**: `.agent/workflows/` (workspace) or global

---

## 4. Agent Modes

| Mode | Behavior | When to use |
|------|----------|-------------|
| **Planning** | Plans -> creates artifacts -> task lists -> research -> then execution | Complex projects, collaborative work, deep research |
| **Fast** | Direct execution without planning | Simple tasks -- rename, bash, quick fixes |

---

## 5. How to Extend

### Add new rule
1. Create `.agent/rules/<name>.md`
2. Define activation description
3. Set activation mode in UI

### Add new skill
1. Create `.agent/skills/<name>/SKILL.md`
2. Add YAML frontmatter with `description`
3. Optionally add `scripts/`, `examples/`, `resources/`

### Add new workflow
1. Create `.agent/workflows/<name>.md`
2. Add YAML frontmatter with `description`
3. Define steps as markdown
4. Invoke via `/<name>`
