---
trigger: model_decision
description: Workflow parameter syntax, scope resolution, and command combination rules
---

# Workflow Syntax System

## Syntax
```
/[workflow] [scope] [/modifier]
```

### Scope (optional)
Agent automatically finds relevant files.
- Empty = entire project
- Component name: `ai-chat`, `game-milionar`, `tmdb-browser`
- Description: `dialog for adding media`
- Technology: `Python`, `XML`, `skin`

Context recognition:
- `/learn sliding window` -> agent searches relevant files
- Ambiguous without `/do` -> ask
- Ambiguous with `/do` -> pick most likely

### Modifiers
- `/do` = execute without waiting
- `/explain` = explain plan before execution
- Another workflow = combination

## Command Combinations
- `/learn /do` = explore + report without asking
- `/analyze /do` = analysis + implementation
- `/audit /fix` = audit + fix all findings
- `/fix X /do` = fix X + execute without asking

## Behavior on Ambiguity

WITHOUT `/do`:
Agent finds multiple options -> asks -> waits for answer

WITH `/do`:
Agent finds multiple options -> picks most likely -> executes

## Examples
```
/learn                     # entire project, waits
/learn wheel-picker        # component
/audit Python              # Python only
/fix training detail       # description
/learn /do                 # explore + report
/audit Python /fix         # audit + fix
```