---
trigger: manual
description: When user requests ElevenLabs voice output, wants the agent to speak via ElevenLabs, asks to change ElevenLabs voice, or wants to stop/mute ElevenLabs playback.
---

# TTS ElevenLabs Voice Output

Activate ElevenLabs TTS mode when user requests spoken output via ElevenLabs. Remains active until user says stop.

## Dual Output

Every response produces:
1. **Text** -- full answer as usual
2. **TTS** -- concise spoken version (1-3 sentences, essence only, no code/URLs/paths)

## TTS Execution

Use `run_command` with curl to ElevenLabs TTS API, then `afplay` in background:

- **API**: `https://api.elevenlabs.io/v1/text-to-speech/{voice_id}`
- **Key**: `sk_759aea75ff43f641554f3892f4554c23f45204c638480b67`
- **Model**: `eleven_flash_v2_5` (low latency, conversational)
- **Voice**: session voice (default `pNInz6obpgDQGcFmaJgB` = Adam)
- **Output**: `.agent/audio/tts_YYYYMMDD_HHMMSS.mp3` (permanent storage)

### Execution pattern

Write JSON payload to temp file via heredoc (avoids shell escaping issues with diacritics), then curl with `-d @file`:

```bash
F=".agent/audio/tts_TIMESTAMP.mp3"
P=".agent/audio/payload.json"
cat > "$P" << 'EOF'
{"text":"TTS text here","model_id":"eleven_flash_v2_5","voice_settings":{"stability":0.5,"similarity_boost":0.75}}
EOF
HTTP=$(curl -s -X POST "https://api.elevenlabs.io/v1/text-to-speech/{voice_id}" \
  -H "xi-api-key: sk_759aea75ff43f641554f3892f4554c23f45204c638480b67" \
  -H "Content-Type: application/json" -H "Accept: audio/mpeg" \
  -d @"$P" -o "$F" -w "%{http_code}")
rm -f "$P"
if [ "$HTTP" = "200" ]; then afplay "$F"; else echo "TTS error ($HTTP): $(cat "$F")"; rm -f "$F"; fi
```

## Voice

Default: `pNInz6obpgDQGcFmaJgB` (Adam). User can change anytime by name or gender.

Gender defaults: male = Adam (`pNInz6obpgDQGcFmaJgB`), female = Rachel (`21m00Tcm4TlvDq8ikWAM`).

Voices -- M: Adam(neutral), Antoni(warm), Josh(deep), Arnold(authoritative). F: Rachel(calm), Domi(energetic), Elli(friendly), Bella(soft).

## Rules

- Skip TTS for trivial confirmations ("ok", "done")
- Never send full response to TTS
- Never block flow waiting for playback
- Voice settings: stability 0.5, similarity_boost 0.75
- On error: print `TTS error (HTTP_CODE): <message>` to chat, skip afplay