---
trigger: manual
description: When user requests the best possible voice, most expressive voice, maximum quality TTS, ElevenLabs v3, or wants to experience full voice expressivity with emotions.
---

# TTS ElevenLabs v3 -- Maximum Expressivity Mode

Aktivuje se když uživatel chce nejlepší/nejexpresivnější hlas. Zůstává aktivní dokud neřekne stop.

## Dual Output

Každá odpověď produkuje:
1. **Text** -- plná odpověď jako obvykle
2. **TTS** -- stručná mluvená verze (1-3 věty) **s audio tags podle kontextu**

## Model a konfigurace

- **Model**: `eleven_v3`
- **API**: `https://api.elevenlabs.io/v1/text-to-speech/{voice_id}`
- **Key**: `sk_759aea75ff43f641554f3892f4554c23f45204c638480b67`
- **Voice**: session voice (default `pNInz6obpgDQGcFmaJgB` = Adam)
- **Output**: `.agent/audio/tts_YYYYMMDD_HHMMSS.mp3`
- **Limit**: max 5 000 znaků na request -- při delším textu rozdělit

### Voice Settings pro v3

> **POZOR:** v3 model podporuje stability POUZE: `0.0` (Creative), `0.5` (Natural), `1.0` (Robust). Jiné hodnoty vyhodí error!

```json
{
  "stability": 0.0,
  "similarity_boost": 0.75,
  "style": 0.0,
  "use_speaker_boost": true
}
```

`stability: 0.0` = Creative mode -- maximální expresivita a variace, ideální pro audio tags.

## Audio Tags -- Povinné použití

Agent MUSÍ aktivně vkládat audio tags do TTS textu podle kontextu odpovědi. Tagy jsou v `[hranatých závorkách]`.

### Výběr tagů podle situace

| Situace | Doporučené tagy |
|---------|-----------------|
| Dobrá zpráva, úspěch | `[excited]`, `[happily]`, `[cheerfully]` |
| Špatná zpráva, chyba | `[sighs]`, `[sorrowful]`, `[frustrated]` |
| Humor, vtip | `[laughs]`, `[playfully]`, `[mischievously]` |
| Vážné téma | `[calm]`, `[matter-of-fact]`, `[dramatically]` |
| Překvapení | `[gasps]`, `[curious]`, `[excited]` |
| Nejistota, přemýšlení | `[hesitates]`, `[pauses]`, `[stammers]` |
| Potvrzení, souhlas | `[cheerfully]`, `[happily]` |
| Varování | `[nervous]`, `[quietly]`, `[seriously]` |

### Kompletní tag paleta

**Emoce:** `[excited]` `[nervous]` `[frustrated]` `[sorrowful]` `[calm]` `[sad]` `[angry]` `[happily]` `[tired]` `[curious]` `[mischievously]`

**Reakce:** `[sigh]` `[sighs]` `[laughs]` `[laughing]` `[gasps]` `[gulps]` `[whispers]` `[crying]` `[clears throat]` `[exhales]` `[panting]` `[snorts]`

**Pacing:** `[pauses]` `[hesitates]` `[stammers]` `[rushed]`

**Tón:** `[cheerfully]` `[flatly]` `[deadpan]` `[playfully]` `[dramatically]` `[sarcastically]` `[matter-of-fact]` `[whiny]` `[whispering]` `[shouting]` `[quietly]` `[loudly]`

**Zvuky:** `[door creaks]` `[clapping]` `[explosion]`

### Pravidla pro audio tags

- Každá TTS odpověď musí mít **minimálně 2-3 tagy**
- Tagy vkládat **přirozeně do textu**, ne hromadně na začátek
- Kombinovat emoce + reakce + pacing pro přirozený výkon
- Nikdy neposílat tagy jako viditelný text v textové odpovědi

### Příklady správného použití

```
[excited] Výborně! [laughs] To je přesně správná odpověď! [cheerfully] Pokračujeme dál.

[sighs] [sorrowful] Bohužel to není správně. [pauses] Správná odpověď byla B. [calmly] Nevadí, zkusíme to znovu.

[curious] Hmm, [hesitates] to je zajímavý dotaz. [thoughtfully] Nech mě to promyslet.
```

## Execution pattern

Write JSON payload to temp file via heredoc (avoids shell escaping issues with diacritics/audio tags), then curl with `-d @file`:

```bash
F=".agent/audio/tts_TIMESTAMP.mp3"
P=".agent/audio/payload.json"
cat > "$P" << 'EOF'
{"text":"[excited] TTS text s tagy.","model_id":"eleven_v3","voice_settings":{"stability":0.0,"similarity_boost":0.75,"style":0.0,"use_speaker_boost":true}}
EOF
HTTP=$(curl -s -X POST "https://api.elevenlabs.io/v1/text-to-speech/{voice_id}" \
  -H "xi-api-key: sk_759aea75ff43f641554f3892f4554c23f45204c638480b67" \
  -H "Content-Type: application/json" -H "Accept: audio/mpeg" \
  -d @"$P" -o "$F" -w "%{http_code}")
rm -f "$P"
if [ "$HTTP" = "200" ]; then afplay "$F"; else echo "TTS error ($HTTP): $(cat "$F")"; rm -f "$F"; fi
```

## Hlas

Default: `pNInz6obpgDQGcFmaJgB` (Adam). Uživatel může změnit kdykoli jménem nebo pohlavím.

Gender defaults: male = Adam (`pNInz6obpgDQGcFmaJgB`), female = Rachel (`21m00Tcm4TlvDq8ikWAM`).

Hlasy -- M: Adam(neutral), Antoni(warm), Josh(deep), George(authoritative). F: Rachel(calm), Charlotte(sophisticated), Aria(conversational).

## Pravidla

- Audio tags VŽDY přidávat -- nikdy je nevynechat
- Limit 5 000 znaků/request -- split dlouhý text
- Nikdy neblokovat flow čekáním na playback
- Triviální potvrzení ("ok", "hotovo") přeskočit
- Nikdy posílat plnou textovou odpověď do TTS
- On error: print `TTS error (HTTP_CODE): <message>` to chat, skip afplay