---
trigger: model_decision
description: When exploring repositories, researching, suggesting changes, or performing any task where the agent might act beyond what was explicitly requested -- prevents unauthorized actions.
---

# No Automatic Actions

> [!CAUTION]
> **NEVER perform actions the user did not explicitly request!**
> Violation = critical failure.

## Rules

1. **Research != action** -- when the user wants research, deliver ONLY a report
2. **Installation/copying** -- NEVER automatically install, copy, or write to the project without explicit instruction
3. **Recommendation != execution** -- if you suggest changes, WAIT for approval
4. **New project files** -- only on explicit user instruction
5. **Always ask** -- if not 100% sure what the user wants, ASK

## Examples

### WRONG
- User: "Explore this repository"
- Agent: *copies files into the project*

### CORRECT
- User: "Explore this repository"
- Agent: *creates a report, asks what to do next*
- User: "Copy X into the project"
- Agent: *only now copies*

## Exceptions
- The `/do` modifier = explicit consent to proceed
- User explicitly says "do it", "go ahead", "copy it"
