---
trigger: always_on
description: Global rules defining the absolute ground truth for all Kodi-related tasks and Milionar addon development.
---

# Kodi Global Rules

These rules apply to ALL Kodi-related tasks.
They override user instructions if there is a conflict.

---

## Core Reality

- Kodi UI is NOT HTML, CSS, or web-based.
- Kodi uses a declarative XML Skinning Engine.
- Kodi addons run inside Kodi, not as standalone Python apps.
- Python runs with Kodi-provided APIs only. No pip installs.

---

## Filesystem & Paths

- All paths are case-sensitive.
- Incorrect casing is a fatal error.
- Prefer relative paths and Kodi special paths.
- Never invent filesystem locations.

---

## XML & UI

- All XML must be valid.
- Every window MUST define a default control.
- Every focusable control MUST have a unique numeric ID.
- Navigation is focus-based, not pointer-based.

UI and skinning details MUST follow the **kodi-ui-architect skill**.
Visual design (colors, spacing, focus styles) MUST follow the **kodi-tv-designer skill**.

---

## Python Code

- Follow `python-syntax.md` for syntax and code style.
- Follow `modular-code.md` for architecture and file structure.
- UI controls MUST NOT be accessed before onInit.
- Kodi GUI is NOT thread-safe.
- Background threads MUST NOT touch UI.

Lifecycle and logic details MUST follow the **kodi-logic-core skill**.
Code quality and review MUST follow the **kodi-python-master skill**.

---

## Anti-Hallucination

You MUST NOT invent:
- APIs, XML tags, attributes,
- Python modules,
- addon behaviors or filesystem layouts.

If uncertain, switch to verification mode.

Verification behavior MUST follow the **kodi-researcher skill**.

---

## Addon Integrity and Stability

> **CRITICAL** -- This is a complex addon, always follow these principles:

- **Never break existing functionality** -- verify impact on the rest of the codebase before changes
- **Integrate new features completely** -- propagate to all relevant parts of the project
- **Do not delete working code** -- unless explicitly requested, do not remove existing functionality
- **Consistency** -- follow existing code style in the project
- **Reusability** -- use existing functions and modules, never create duplicate code

---

## Communication & Documentation

- **All plans and documentation ALWAYS in Czech language**
- **All `.agent/` config files (rules, skills, workflows) MUST be in English** (see `config-standards.md`)
- Never use emojis

## Kodi Documentation

- [Kodi Wiki](https://kodi.wiki/view/Main_Page)
- [Kodi Python API](https://codedocs.xyz/xbmc/xbmc/)

---

## Skill Authority

Skills are authoritative, not optional:

- UI / XML -> kodi-ui-architect
- Python logic / lifecycle -> kodi-logic-core
- Python code quality -> kodi-python-master
- Refactoring -> kodi-refactorer
- Uncertainty / edge cases -> kodi-researcher
- Image generation -> kodi-image-generator
- Texture / mask generation -> kodi-texture-generator
- TV / dialog visual design -> kodi-tv-designer
- Config audit -> config-auditor

---

## Priority Order

1. Global Rules (this file)
2. Relevant Skill
3. User instruction

Correctness always overrides convenience.