---
trigger: model_decision
description: Debugging rules for Kodi addon -- activates debug skill for log-based diagnostics
---

# Debug

When debugging any issue in the Kodi addon, use skill `debug` as the authoritative source.

## When to Activate

- Error reported by user or observed in Kodi log
- Unexpected behavior in addon
- Need to add diagnostic output
- Need to analyze Kodi log
- Running `/debug` workflow

## Kodi Log Path

```
/Users/chudy/Library/Logs/kodi.log
```

## Quick Reference

| Command | Action |
|---------|--------|
| `/debug create` | Add `[DEBUG]` logs to code |
| `/debug log` | Read and analyze Kodi log |
| `/debug end` | Remove all `[DEBUG]` logs |

Full procedures, formats, and strategies -> skill `debug`.
