---
trigger: model_decision
description: When creating or editing agent configuration -- rules, skills, workflows in .agent/ directory
---

# Config Standards

When creating configuration ALWAYS:
- Use skill `config-creator`
- Check that a similar one does not already exist
- Follow the style of existing files

## Language Rule

> [!IMPORTANT]
> All `.agent/` configuration files (rules, skills, workflows) MUST be written in **English**.
> This ensures optimal LLM comprehension -- training data is predominantly English.
> Communication with the user remains in Czech (per `czech-communication.md`).

## Structure
- Rule: `.agent/rules/[name].md`
- Skill: `.agent/skills/[name]/SKILL.md`
- Workflow: `.agent/workflows/[name].md`

## Required elements

### Rule
- Activation mode set via **UI** (Always On, Manual, Model Decision, Glob)
- `trigger:` and `description:` may be added in YAML frontmatter for documentation
- Max 12,000 characters
- Supports `@filename` references to other files

### Skill
- Folder + `SKILL.md` with YAML frontmatter
- `name:` -- skill identifier
- `description:` -- clear, detailed description with "Use when..." pattern and keywords for agent discovery
- Role description in first person ("You are...") is optional but recommended
- Progressive disclosure: only `description` loaded initially, full SKILL.md loaded on activation

### Workflow
- `description:` -- short description in YAML frontmatter
- Invoked via `/workflow-name` slash command
- Numbered steps with clear actions
- Max 12,000 characters

## Token Efficiency

> [!CAUTION]
> **NO markdown tables in any `.agent/` files!**
> Tables waste tokens and add zero value for LLM comprehension.
> Use bullet points and plain text instead.

- Prefer short bullet lists over verbose formatting
- One concept per line
- If you can say it in a sentence, don't make it a table

## PROHIBITED
- Markdown tables (use bullet points instead)
- Empty or vague description
- TODO or placeholder content
- Duplicate configuration
- Non-existent references
- `trigger:` field in skill YAML frontmatter -- use `description:` for discovery keywords
