---
trigger: model_decision
description: When accessing addon data, settings, cache, user files, or filesystem paths for the Kodi addon
---

# Addon Filesystem Paths

All paths for `plugin.video.milionar` on macOS.

## Addon Source (code, resources, XML)
`/Users/chudy/Library/Application Support/Kodi/addons/plugin.video.milionar/`

## Addon Data (settings, user data, cache)
`/Users/chudy/Library/Application Support/Kodi/userdata/addon_data/plugin.video.milionar/`

Kodi stores all addon runtime data here (`special://profile/`).

Contents:
- `settings.xml` -- addon settings (API keys, preferences)
- `ai_usage_stats.json` -- AI usage statistics
- `mytv_channels.json` -- MyTV channel configuration
- `global_watch_history.json` -- watch history
- `search_history.json` -- search history
- `watchlist_movies.json` / `watchlist_series.json` -- watchlists
- `cache/` -- runtime cache (API responses, metadata)
- `channel_icons/` -- downloaded channel icons
- `img_cache/` -- image cache
- `mytv_history/` -- per-channel watch history/progress

## Kodi Userdata Root
`/Users/chudy/Library/Application Support/Kodi/userdata/`

## Path Resolution in Python

```python
# Addon data directory
addon_data = xbmcvfs.translatePath(xbmcaddon.Addon().getAddonInfo('profile'))
# Addon source directory
addon_source = xbmcvfs.translatePath(xbmcaddon.Addon().getAddonInfo('path'))
```

> [!CAUTION]
> Never use `special://` paths with `os.path` or `open()`. Always translate first with `xbmcvfs.translatePath()`.

> [!CAUTION]
> **Addon data (settings, history, cache) are NEVER inside the addon source directory!**
> - WRONG: `/Users/chudy/Library/Application Support/Kodi/addons/plugin.video.milionar/userdata/`
> - RIGHT: `/Users/chudy/Library/Application Support/Kodi/userdata/addon_data/plugin.video.milionar/`
>
> When looking for JSON files (history, settings, cache), ALWAYS use the addon data path above.
> The addon source directory contains ONLY code, XML, and static resources.
