---
description: Vytvoření uživatelské příručky aplikace
---

# /user-guide

Syntaxe: viz `workflow-syntax.md` — `/do` = vytvoří bez ptaní

Vytváří `docs/USER_GUIDE.md` — příručku pro běžné uživatele.

ZAKÁZÁNO uvádět:
- Programovací jazyky, frameworky
- Názvy souborů, CSS tříd, JS funkcí
- Technické termíny (localStorage, service worker, DOM, API...)

## Postup

### 1. Kompletní analýza
Projdi VŠECHNY:
- HTML šablony → stránky/views
- JavaScript moduly → funkce pro uživatele
- Existující docs/
- Navigaci

### 2. Křížová kontrola s README
Pro každou funkci v README ověř:
- Má sekci v USER_GUIDE?
- Je popsána z pohledu uživatele?

### 3. Mapping funkcí
View/Šablona → Funkce → Sekce v příručce

### 4. Vytvoř příručku

Struktura:
- Co aplikace umí (kompletní seznam)
- Instalace (prohlížeč, iPhone, Android)
- Jak začít
- Používání (sekce pro každou stránku/funkci)
- Nastavení (tabulka)
- FAQ
- Řešení problémů

## Přepis technických termínů
- "Data se ukládají do localStorage" → "Vaše data se automaticky ukládají"
- "PWA s offline podporou" → "Aplikace funguje i bez internetu"
- "Responsivní design" → "Přizpůsobí se velikosti obrazovky"

## Kontrola
- Každá stránka/view má sekci?
- Každá funkce z README pokryta?
- Všechny položky navigace popsány?
- Žádné technické termíny?
