---
description: Synchronizace .agent/ konfigurace z jiného projektu — porovná, adaptuje, nahraje
---

# /sync

Synchronizace rules, skills a workflows z jiného projektu do tohoto.
Zdrojová složka: `.agent/other/.agent/`

## Režimy
- `/sync` — porovnání + diff + **ČEKÁNÍ NA SCHVÁLENÍ** (výchozí)
- `/sync do` — porovnání + rovnou aplikovat bez ptaní

> [!CAUTION]
> **BEZ `/do` modifikátoru NIKDY neaplikuj změny!**
> Výchozí `/sync` = POUZE report + čekání na explicitní schválení.
> Aplikace změn POUZE po uživatelově "ok", "ano", "schvaluji" nebo `/do`.

## Postup

### 1. Sken zdrojové složky
Projdi celý `.agent/other/.agent/` — rules, skills, workflows.
Pro každý soubor zjisti zda v naší `.agent/` existuje ekvivalent.

Kategorizuj:
- **NEW** — soubor v naší `.agent/` neexistuje
- **MODIFIED** — soubor existuje ale liší se od zdrojového
- **IDENTICAL** — soubor existuje a je stejný (přeskočit)

### 2. Analýza každého NEW/MODIFIED souboru
Pro každý soubor proveď:

1. **Zkontroluj hardcoded reference** na zdrojový projekt:
   - Názvy projektů, addonů, aplikací
   - Specifický tech stack (Kodi API, xbmc.*, React, Django, atd.)
   - Hardcoded cesty, API klíče, voice ID
   - Projektově-specifické příklady

2. **Rozhodni akci:**

| Situace | Akce |
|---------|------|
| Soubor je obecný (žádné hardcoded) | Zkopírovat/přepsat 1:1 |
| Obsahuje hardcoded ale jde zobecnit | Přepsat na obecné formulace |
| Tak specifický že se musí přepsat celý | Přepsat celý s naším kontextem |
| Pro náš projekt nedává smysl | Přeskočit (nepřidávat) |

3. **Pravidla přepisu:**
   - Preferuj obecné formulace fungující pro jakýkoliv projekt
   - Pokud to obecně nejde — adaptuj na náš tech stack
   - Nikdy nenechávej reference na jiný projekt/stack
   - Zachovej styl a formát existujících souborů v naší `.agent/`

### 2.5. Extrakce principů z přeskočených souborů (EXTRACT)
I soubory označené jako SKIP mohou obsahovat obecně platné principy, metodologie
nebo vzory, které náš projekt nemá. Pro každý SKIP soubor:

1. **Analyzuj obsah** — hledej obecné koncepty nezávislé na tech stacku
   - Metodologie (debug workflow, scientific method, checklists)
   - Architektonické vzory (placement strategy, lifecycle hooks)
   - Best practices (error handling patterns, naming conventions)
   - Nové sekce nebo struktury které naše ekvivalenty nemají

2. **Porovnej s našimi ekvivalenty** — máme rule/skill/workflow pro stejnou doménu?
   - Pokud ano: navrhni obohacení našeho souboru o nalezené principy
   - Pokud ne a principy jsou hodnotné: navrhni vytvoření obecné verze

3. **Výstup:** Pro každý SKIP soubor kde byly nalezeny přenositelné principy:
```
## EXTRACT z [název souboru]
**Nalezené principy:** [co je přenositelné]
**Cíl integrace:** [který náš soubor obohatit]
**Navrhované změny:** [konkrétní doplnění]
```

### 3. Prezentace návrhu
Pokud **není** režim `/sync do`:

Pro každý soubor ukaž:
- Kategorie (NEW/MODIFIED/SKIP/EXTRACT)
- Důvod akce
- Diff změn (pokud MODIFIED)
- Upozornění na přepsané hardcoded reference

Formát:
```
## [KATEGORIE] [typ] [název souboru]
**Důvod:** [proč přidáváme/upravujeme/přeskakujeme]
**Hardcoded nalezeno:** [co bylo přepsáno, nebo "nic"]
[diff nebo popis změn]
```

Čekej na schválení před aplikací.

### 4. Aplikace změn
- Zkopíruj/přepiš soubory podle schváleného návrhu
- Dodržuj strukturu: rules → `.agent/rules/`, skills → `.agent/skills/[name]/SKILL.md`, workflows → `.agent/workflows/`
- Aplikuj schválené EXTRACT návrhy do existujících souborů

### 5. Úklid
// turbo
Smaž celou složku `.agent/other/.agent/` po dokončení:
```bash
rm -rf .agent/other/.agent
```

### 6. Shrnutí
Vypiš co bylo:
- Přidáno (NEW)
- Aktualizováno (MODIFIED)
- Obohaceno (EXTRACT) + co bylo přidáno kam
- Přeskočeno (SKIP) + důvod
- Smazáno (úklid)

## Pravidla
- NIKDY nenechávej hardcoded reference na jiný projekt
- NIKDY nepřeskakuj soubor bez vysvětlení
- NIKDY nepřeskakuj soubor bez kontroly přenositelných principů (EXTRACT)
- VŽDY projdi KAŽDÝ soubor — nic nevynechávej
- Pokud si nejsi jistý zda soubor adaptovat nebo přeskočit — zeptej se
- Dodržuj `config-standards` rule pro formát souborů
