---
description: SQL operace na serveru přes SSH — migrace, schema changes, seed data, queries
---

# /ssh-sql

Workflow pro SQL operace na vzdáleném serveru.

## Konfigurace

```
HOST: hosting.pilsfree.net
USER: chudy
DB_PASSWORD: fE9km3eekS
DB: users_chudy1 (magazine), users_chudy (tricoach), users_chudy2 (volná)
```

> [!IMPORTANT]
> **Agent provádí všechno sám.** Uživatel nemusí na server.

## Kroky

// turbo-all

### 1. Připrav SQL soubor lokálně
Vytvoř SQL soubor v `api/db/` nebo `/tmp/`.

### 2. Nahraj a spusť SQL na serveru
```bash
cat {SQL_FILE} | ssh chudy@hosting.pilsfree.net "mysql -u chudy -pfE9km3eekS {DB_NAME}"
```

### 3. Ověř výsledek
```bash
ssh chudy@hosting.pilsfree.net "mysql -u chudy -pfE9km3eekS {DB_NAME} -e 'SHOW TABLES;'"
```

## Běžné operace

### Schema change
```bash
ssh chudy@hosting.pilsfree.net "mysql -u chudy -pfE9km3eekS {DB_NAME} -e 'ALTER TABLE ...'"
```

### Quick query
```bash
ssh chudy@hosting.pilsfree.net "mysql -u chudy -pfE9km3eekS {DB_NAME} -e 'SELECT COUNT(*) FROM articles'"
```

### Drop + recreate table
```bash
ssh chudy@hosting.pilsfree.net "mysql -u chudy -pfE9km3eekS {DB_NAME} -e 'DROP TABLE IF EXISTS table_name'"
cat api/db/schema.sql | ssh chudy@hosting.pilsfree.net "mysql -u chudy -pfE9km3eekS {DB_NAME}"
```

### Export dat
```bash
ssh chudy@hosting.pilsfree.net "mysqldump -u chudy -pfE9km3eekS {DB_NAME} table_name" > backup.sql
```

## Related

- **Rule** `ssh-server-operations` → full SSH server admin (always-on)
- **Skill** `sql-mariadb` → PHP PDO, schema design, SSH SQL section
- **Workflow** `/deploy` → rsync + Safari reload
