---
description: Kompletní vymazání cache a hard reload Safari + bump verze CSS + SW
---

# /safari-reload

Kompletní workflow pro vymazání cache a načtení čerstvé verze webu.

## Kdy použít
- Po úpravě CSS/HTML/JS
- Když stránka nenačítá nové změny
- Při 404 na nové soubory

## Kroky

// turbo-all

### 1. Bump CSS verze
```bash
sed -i '' 's/styles\\.css?v=[0-9]*/styles.css?v='$(date +%s)'/' index.html
```

### 2. Bump Service Worker verze
Automaticky inkrementuje číslo verze v `CACHE_NAME` v `sw.js`. Zabrání servírování starých JS/HTML z SW cache.

```bash
perl -i -pe 's/(freq-v)(\d+)/sprintf("%s%d",$1,$2+1)/e' sw.js
```

### 3. Empty Caches + Hard Reload
```bash
osascript -e 'tell application "Safari" to activate' -e 'delay 0.2' -e 'tell application "System Events"' -e 'keystroke "e" using {option down, command down}' -e 'delay 0.3' -e 'keystroke "r" using {option down, command down}' -e 'end tell'
```

## Co to dělá
1. CSS bump = přepíše `styles.css?v=XX` na aktuální timestamp
2. SW bump = inkrementuje verzi `freq-vN` → `freq-v(N+1)` → invaliduje starý SW cache
3. Cmd+Option+E = Empty Caches
4. Cmd+Option+R = Hard Reload

Funguje pouze na macOS s otevřeným Safari.
