---
description: Kompletní report a audit poslední radio inference session
---

# /radio-report

Report a analýza radio inference sessions.

## Konfigurace

> [!IMPORTANT]
> **URL a server config** — viz pravidlo `remote-testing` (BASE_URL, curl vzory).
> **SSH a SQL fallback** — viz pravidlo `ssh-server-operations` (SSH, MySQL příkazy).
> NEDUPLIKUJ konfiguraci — vždy čti z těchto pravidel.

### API endpoint

```
GET {BASE_URL}/api/radio-last.php
```

Parametry:
- `?action=list` — seznam sessions
- `?session_id=radio_...` — detail konkrétní session
- Bez parametrů — poslední session

### SQL fallback (pro data mimo API)

Tabulky:
- **`radio_sessions`** — session_id, article_id, radio_config, llm_config, prompt_style, personas, stats
- **`radio_messages`** — session_id, role, content, track, meta, created_at
- **`generation_logs`** — type (success/error), source (`radio-inference`), message, context (JSON)

---

## Módy

### 1. Bez parametrů → list + detail posledního

```
/radio-report
```

1. Curl `?action=list` → vypiš tabulku sessions (viz formát níže)
2. Curl bez parametrů → vypiš normální detail posledního rádia (viz formát níže)

---

### 2. `list` → pouze seznam sessions

```
/radio-report list
```

Curl `?action=list` → tabulka:

| Session ID | Rádio | Moderátor | Kola | Tokeny | Cost | Čas |
|------------|-------|-----------|------|--------|------|-----|

---

### 3. `detail [session_id]` → absolutní flow detail

```
/radio-report detail
/radio-report detail radio_2026-02-17_14-04-58_14dafb
```

Bez session_id = poslední. S ID = konkrétní.

#### Zdroje dat

- **Session + rounds** → curl `?session_id=...`
- **System prompt + flow** → SQL fallback:
  ```sql
  SELECT context FROM generation_logs
  WHERE source='radio-inference' AND type='success'
  AND message LIKE '%{session_id}_msg1%'
  ORDER BY id DESC LIMIT 1
  ```
  `context` je JSON → klíče: `system_prompt`, `flow[]`, `user_message`, `raw_commentary`, `parsed_comments`, `usage`, `llm_config`

#### Obsah reportu

1. **Přehled** — tabulka: rádio, moderátor, voice, LLM model, tracků, doba, cost, tokeny
2. **LLM konfigurace** — JSON blok (provider, model, temperature, top_p, penalties, max_tokens)
3. **System prompt** — celý, formátovaný čitelně (jednou)
4. **Pro každé kolo:**
   - `🎵 Kolo N — Track (Artist)`
   - Čas, duration, tokeny, cost
   - 📤 iOS message (raw) — dekódovaný JSON (track, gps, weather, playlist, is_first)
   - 📝 LLM user message — finální text poslaný LLM
   - Flow kroky (✅/❌)
   - 📥 Komentáře — A (main), B (mid), C (end), D (post)
5. **Statistiky:**
   - Tabulka: Kolo | Track | Čas | Prompt | Completion | Total | Cost
   - Null pattern: Kolo | A | B | C | D (✅/null)
6. **Audit** (kontroly):
   - Double-encoded JSON v track/gps/playlist?
   - Opakující se komentáře?
   - Dodržení limitů slov (3-8)?
   - Null pattern přirozený?
   - Kontinuita (správný název dalšího tracku)?
   - GPS/Počasí reakce?
   - Response časy konzistentní?

---

### 4. `errors [session_id]` → analýza error záznamů

```
/radio-report errors
/radio-report errors radio_2026-02-17_14-04-58_14dafb
```

Bez session_id = poslední error. S ID = errory dané session.

SQL:
```sql
SELECT id, message, context, created_at FROM generation_logs
WHERE source='radio-inference' AND type='error'
ORDER BY id DESC LIMIT 5
```

Pro konkrétní session:
```sql
... AND context LIKE '%{session_id}%'
```

Pro každý error vypiš:
- 🕐 Čas + error message
- Flow kroky (z `context.flow[]`)
- Input data (z `context.input`)
- Stack trace (pokud existuje)
- Závažnost: 🔴 CRITICAL (500, fatal) / 🟡 WARNING (4xx, validace)

---

## Normální detail (formát)

Přehledový formát pro default mód — bez flow kroků a system promptu.

1. **Přehled** — tabulka: rádio, moderátor, voice, LLM, kola, tokeny, cost
2. **Playlist** — očíslovaný seznam tracků (✅ odehrané, ← aktuální)
3. **Komentáře posledního kola** — tabulka: typ | komentář
4. **Statistiky** — celkové tokeny, cost, průměrný čas na kolo

---

## Výstup

- **Vždy do chatu** — formátovaný markdown
- **Audit report do souboru** POUZE na explicitní žádost uživatele → `docs/audits/radio-report-YYYY-MM-DD.md`
- **NIKDY automatický audit report** — jen na vyžádání

## Pravidla

- Report MUSÍ být kompletní — žádné vynechání kola
- System prompt vypsat CELÝ (jednou, jen v detail módu)
- User messages dekódovat z escaped JSON do čitelné podoby
- Pokud je víc sessions ve stejný den, přidej suffix `-2`, `-3`
- Preferuj API curl, SQL jen pro data která API nevrací
