---
description: Prozkoumej, nauč se a analyzuj funkci projektu nebo jeho konkrétní části
---

# /learn

Syntaxe: viz `workflow-syntax.md` — scope: komponenta/popis/screenshot, `/do` = vytvoří report bez ptaní

## Účel
Hloubkové prozkoumání a pochopení projektu, jeho části, nebo vizuálního designu.

## Režimy vstupu

### 1. Textový vstup
- `/learn` — celý projekt
- `/learn [komponenta]` — konkrétní část (např. `wheel-picker`)
- `/learn [slovní popis]` — agent najde relevantní soubory

### 2. Screenshot vstup
- `/learn` + screenshot(y) — pochop vizuální design a najdi/vytvoř implementaci
- `/learn` + screenshot bez textu — analyzuj co vidíš, identifikuj v projektu

## Screenshot analýza

VŽDY analyzuj screenshot jako **iPhone PWA v standalone režimu**:

1. **Identifikuj prvky:**
   - Layout (flex/grid, směr, zarovnání)
   - Komponenty (tlačítka, karty, modaly, inputy)
   - Typografie (velikost, váha, barva)
   - Barvy (pozadí, text, akcenty)
   - Spacing (gap, padding, margin)
   - Shadows, border-radius, efekty

2. **Buď PRECIZNÍ:**
   - Každý pixel má význam
   - Všímej si detailů (1px border, subtle shadows)
   - Porovnej s existujícím designem projektu

3. **Podle kontextu:**
   - **Pochopení**: Najdi odpovídající kód v projektu
   - **Replikace**: Vytvoř nový kód podle screenshotu
   - **Kombinace**: Pochop existující + doplň chybějící

## Chování
- `/learn` — prozkoumá, zeptá se co dál
- `/learn /do` — prozkoumá + vytvoří report
- `/learn` + screenshot — analyzuje, zeptá se na záměr
- `/learn` + screenshot `/do` — analyzuje + implementuje

## Postup

### 1. Urči typ vstupu
- Text → vyhledej v codebase
- Screenshot → analyzuj vizuál
- Kombinace → propoj obojí

### 2. Prozkoumej/Analyzuj
**Textový vstup:**
- `list_dir`, `view_file_outline`
- `.agent/rules/`, `docs/`
- Závislosti a flow

**Screenshot vstup:**
- Detailní vizuální analýza
- Porovnání s existujícími komponentami
- Identifikace CSS patterns

### 3. Propoj s projektem
- Najdi odpovídající soubory
- Identifikuj existující patterns
- Urči co existuje vs. co chybí

### 4. Výstup
- S `/do`: Report do `docs/knowledge/[název].md`
- Bez `/do`: Shrň nálezy, zeptej se co dál
- Screenshot: Navrhni implementaci nebo popiš nalezený kód

## Formát reportu
```
# Knowledge: [Název]
**Vytvořeno**: [YYYY-MM-DD HH:mm]
**Scope**: [co bylo zkoumáno]
**Zdroj**: [text/screenshot/kombinace]

## Účel
## Soubory
## Hlavní funkce/Vizuální prvky
## Flow (mermaid)
## Závislosti
## Poznámky
```

## Kombinace
- `/learn /do` — prozkoumá + report
- `/learn /analyze` — prozkoumá + analýza problémů
- `/learn /audit` — prozkoumá + audit kvality
