---
description: Vytvoření nebo aktualizace dokumentace dokončené/rozpracované funkce
---

# /feature

Syntaxe: viz `workflow-syntax.md` — scope: název funkce/popis, `/do` = vytvoří bez ptaní

> [!IMPORTANT]
> **Hlavní cíl**: Dokumentace MUSÍ být dostatečně soběstačná, aby NOVÝ NEZÁVISLÝ AGENT
> bez jakéhokoliv kontextu plně porozuměl funkci a okamžitě mohl:
> upravit kód, přidat funkcionalitu, změnit grafiku, opravit bugy.
>
> **Rovnováha**: Buď kompletní, ale šetři tokeny. Žádný filler, žádné opakování.
> Používej reference (cesty k souborům, rozsah řádků) místo kopírování kódu.

---

## Detekce režimu

Tři režimy — agent určí automaticky:

### 1. AUTO-UPDATE (výchozí, bez parametrů)
**Trigger**: `/feature` without parametrů
**Intent**: Uživatel právě dokončil práci a chce aktualizovat veškerou dotčenou dokumentaci.

**Procedure**:
1. **Zjisti kontext session** — z konverzační historie, aktivních dokumentů, a posledních změn pochop CO se právě dělalo
2. **Prohledej CELÝ adresář `docs/`** (všechny podadresáře: features, knowledge, issues, audits, research, atd.)
3. **Identifikuj VŠECHNY relevantní docs** — každý soubor, který se jakkoliv týká změněných souborů, upravené funkcionality, nebo dotčených komponent
4. **Přečti každý relevantní doc** a porovnej s aktuálním stavem codebase
5. **Aktualizuj každý doc** kde obsah neodpovídá realitě:
   - File Map — přidej/odeber/uprav soubory
   - Key Interfaces — aktualizuj signatury
   - Architecture — uprav pokud se změnil data flow
   - Dependencies — aktualizuj pokud se změnily vazby
   - Přidej `## Updated: [YYYY-MM-DD HH:mm]`
6. **Shrň** co bylo aktualizováno (seznam docs + stručně co se změnilo)

> [!CAUTION]
> Neopomeň ŽÁDNÝ relevantní doc. Prohledej VŠECHNY podadresáře v `docs/`.
> Nestačí jen `docs/features/` — kontroluj i `docs/knowledge/`, `docs/issues/`, atd.

---

### 2. FULL AUDIT (`/feature all`)
**Trigger**: `/feature all`
**Intent**: Kompletní audit VŠECH docs vs. aktuální stav codebase.

**Procedure**:
1. **Načti seznam VŠECH .md souborů** v celém adresáři `docs/` (rekurzivně)
2. **Pro každý doc**:
   a. Přečti obsah
   b. Zkontroluj File Map — existují soubory? Jsou role aktuální?
   c. Zkontroluj Key Interfaces — odpovídají signatury?
   d. Zkontroluj Architecture — odpovídá aktuálnímu kódu?
   e. Zkontroluj Dependencies — jsou aktuální?
   f. Zkontroluj Status — je COMPLETED/IN_PROGRESS správně?
3. **Aktualizuj všechny docs** kde obsah neodpovídá realitě
4. **Report** — tabulka všech docs s výsledkem (✅ aktuální / 🔄 aktualizován / ⚠️ problém)

> [!WARNING]
> Toto je náročná operace. U velkých projektů může trvat déle.
> Každý doc MUSÍ být porovnán se skutečným kódem, ne jen zběžně přečten.

---

### 3. CREATE (nová feature doc)
**Trigger**: Agent pozná z kontextu, že uživatel chce vytvořit NOVOU dokumentaci
- Zadání popisuje novou feature co ještě nemá doc
- Explicitní zmínka "nový", "vytvoř", "zdokumentuj"
- Pokud je nejasné jestli CREATE nebo UPDATE → **doptej se**

**Postup**:
1. Zeptej se uživatele (bez `/do`):
   - Název funkce
   - Status (completed/in-progress)
   - Stručný popis (1 věta)
2. Zkontroluj `docs/features/` pro další index
3. Pojmenuj `[XXX]-[name].md` (kebab-case)
4. Analyzuj relevantní kód důkladně — pochop architekturu, ne jen povrch
5. Vytvoř dokumentaci podle struktury níže
6. Self-check: "Mohl by nový agent upravit tuto funkci jen z tohoto docu?" Pokud ne, doplň co chybí

---

## Struktura dokumentace

### Povinné sekce
1. **Header** — Název, Status (COMPLETED/IN_PROGRESS/PLANNED), datum vytvoření/aktualizace
2. **Účel** — Co funkce dělá a PROČ (1-3 věty)
3. **Architektura** — Jak to funguje, data flow, klíčová rozhodnutí (diagram pokud je to složité)
4. **File Map** — Každý relevantní soubor s jeho rolí (tabulka):
   | Soubor | Role |
   | --- | --- |
   | `path/to/file.py` | Popis |
5. **Key Interfaces** — Veřejné funkce/třídy které agent potřebuje znát (signatura + 1 řádek popisu, NE celý kód)
6. **UI Components** — obrazovky/views, komponenty, šablony, assety, layout (pokud je to relevantní)
7. **Dependencies** — Na čem tato funkce závisí a co závisí na ní
8. **How to Extend** — Konkrétní kroky pro běžné úpravy (přidej nové X, změň Y)
9. **TODO** — Zbývající práce (pouze pro IN_PROGRESS)

### Pravidla
- **File links** s rozsahem řádků: `[file.py](file:///path#L10-L30)` — nikdy nevkládej velké bloky kódu
- **Tabulky místo prózy** pro strukturovaná data (soubory, ovládací prvky, nastavení)
- **Max ~300 řádků** per feature doc — pokud je to delší, rozděl nebo zkrať
- **Žádné spekulace** — dokumentuj jen to co existuje
- **Žádný plný zdrojový kód** — pouze signatury a reference
