---
description: Deploy projektu na server — rsync, Safari reload
---

# /deploy

Deploy workflow: sync na server, reload Safari.

## Kdy použít
- Po úpravě CSS/HTML/JS/PHP
- Když chceš nahrát změny na server

## Konfigurace

```
HOST: hosting.pilsfree.net
USER: chudy
REMOTE_PATH: /home/chudy/public_html/{PROJECT_NAME}/
LOCAL_PATH: <automaticky z workspace URI agenta>
BASE_URL: http://hosting.pilsfree.net/chudy/{PROJECT_NAME}/
AUTH: SSH klíč (uložený v systému)
```

> [!IMPORTANT]
> **Dynamické cesty — agent MUSÍ před spuštěním:**
> 1. Zjistit `{PROJECT_ROOT}` z aktuálního workspace URI
> 2. Odvodit `{PROJECT_NAME}` z názvu posledního adresáře v cestě (basename)
> 3. Dosadit obě hodnoty do všech příkazů níže

## Kroky

// turbo-all

### 1. Rsync na server
```bash
rsync -avz --delete --exclude='/data/' {PROJECT_ROOT}/ chudy@hosting.pilsfree.net:/home/chudy/public_html/{PROJECT_NAME}/
```

### 2. Safari Empty Caches + Hard Reload
```bash
osascript -e 'tell application "Safari" to activate' -e 'delay 0.2' -e 'tell application "System Events"' -e 'keystroke "e" using {option down, command down}' -e 'delay 0.3' -e 'keystroke "r" using {option down, command down}' -e 'end tell'
```

## Co to dělá
1. **Rsync** — nahraje jen změněné soubory přes SSH na server, `--delete` smaže soubory které lokálně neexistují
2. **Safari reload** — Empty Caches (Cmd+Opt+E) + Hard Reload (Cmd+Opt+R)

Funguje pouze na macOS s otevřeným Safari a nastaveným SSH klíčem.

## Related

- **Rule** `ssh-server-operations` → full SSH server admin (always-on)
- **Rule** `remote-testing` → curl API testing after deploy
- **Workflow** `/ssh-sql` → SQL operations on server