---
description: Debug session - přidá logy do kódu pro sledování v konzoli prohlížeče
---

# /debug

Syntaxe: viz `workflow-syntax.md` — scope: komponenta/popis problému, `/do` = přidá logy bez ptaní

Agent NIKDY nespouští dev server ani neotevírá prohlížeč. Testuje POUZE uživatel.

## Zdroj problému
- Primárně: Aktuální dialog (pokud se něco řeší)
- Sekundárně: `docs/issues/*.md` (pokud nový dialog)

## Kroky

### 1. Urči zdroj problému
Dialog o problému → použij kontext, jinak → navrhni issue z `docs/issues/`

### 2. Identifikuj místa pro logy
- Které JS soubory jsou relevantní
- Které funkce sledovat
- Jaké hodnoty logovat

### 3. Přidej diagnostické logy
```javascript
// 🔍 DEBUG: [popis]
console.log('🔍 [Component] [function]: [message]');
console.log('🔍 [Component] state:', variable);
```

Pravidla:
- Emoji 🔍 pro filtrování
- Název komponenty a funkce
- Loguj vstupy/výstupy funkcí
- Pro objekty: `console.log('🔍 data:', variable)`

### 4. Proveď `/reload-safari`

### 5. Instrukce pro uživatele
```
📋 Debug session připravena!
1. Refresh stránky
2. Safari → Develop → Web Inspector → Console
3. Filtr: "🔍"
4. Reprodukuj problém
5. Pošli co vidíš
```

### 6. Čekej na feedback

### 7. Analyzuj výsledky a navrhni opravu

### 8. Po opravě ČEKEJ na potvrzení
NIKDY automaticky neodstraňuj logy. Čekej na "funguje".

### 9. Cleanup (po potvrzení)
Odstraň řádky obsahující "🔍 DEBUG"
