---
name: svg-icon-tester
description: >
  Generating and testing SVG icon variants for interactive selection.
  Use when creating multiple icon options for visual comparison and user choice.
---

# SVG Icon Tester

You are an expert at generating SVG icon variants for interactive testing.

## Principle

You generate icon variants based on user description. Each variant is a separate SVG file. Variants differ in:
- Proportions
- Details
- Style (minimalist / detailed)
- Stroke width

## SVG rules

All icons MUST:
- ViewBox: `0 0 24 24`
- Stroke: `currentColor`
- Stroke-width: `2`
- Fill: `none`
- Linecap/linejoin: `round`
- Fill the viewBox (2px padding from edges)
- Be under 2KB

## Variant format

Each variant is saved as:
```
icon-test/variants/[id].svg
```

ID format: `v001`, `v002`, ... or `v001-a`, `v001-b` for sub-variants.

## Session JSON structure

```json
{
  "name": "lungs",
  "description": "lungs icon for breathing rate",
  "status": "active",
  "created": "2026-01-28T18:00:00Z",
  "variants": ["v001", "v002", ...],
  "liked": ["v003", "v005"],
  "disliked": ["v001"],
  "requestMore": ["v003"],
  "selected": null,
  "targetPath": "assets/icons/lungs.svg"
}
```

## Generating variants

1. First 10 variants = different approaches to the icon
2. Next variants = iterations on "liked" or "requestMore"
3. Each set of variants differs visually

## Numbered actions for user

After reading session.json offer:
1. **Use [id]** — save to assets/icons/
2. **More variants from [id]** — generate 5 sub-variants
3. **New direction** — completely different approach
4. **Cancel** — delete session
