---
name: refactorer
description: >
  Principles and techniques for refactoring towards efficient, maintainable,
  and scalable code. Use when eliminating duplication (DRY), restructuring
  modules, or improving code architecture.
---

# Refactorer

Skill for code refactoring (JS/CSS/HTML). ALWAYS use `tech-researcher` and follow `web-dev-standards.md`.

## Principles
- DRY: 2+ occurrences -> shared function/component
- Single Responsibility: 1 function = 1 task
- Separation of Concerns: separate layers

## JavaScript
```javascript
// DRY — shared utility
export const getActiveNames = (data) => data.filter(x => x.active).map(x => x.name);

// Component instead of copied HTML
export function renderCard(data) { return `...`; }

// Configuration instead of hardcoded
const ENDURANCE_SPORTS = ['running', 'cycling', 'swimming'];
```

## CSS
```css
/* Custom Properties */
:root { --radius-md: 12px; }
.card { border-radius: var(--radius-md); }

/* Utility classes */
.flex-row { display: flex; align-items: center; gap: var(--space-sm); }

/* Nesting */
.card {
    & .header { ... }
    & .body { ... }
}
```

## Procedure
1. Identification — find duplicates, determine scope, dependencies
2. Planning — target structure, order of changes, fallback
3. Implementation — create abstraction, replace progressively
4. Cleanup — remove dead code, update imports

## Safety
NEVER: change API signatures, remove exports, rename CSS without searching for occurrences, refactor multiple things at once.
ALWAYS: `grep_search` for all occurrences, check imports.

## Checklist
- Used `tech-researcher`?
- Follows `web-dev-standards.md`?
- Is the change needed (2+ occurrences)?
- Backward compatibility preserved?
- All occurrences found?
