---
name: pwa-mobile-app
description: >
  Fullscreen PWA for iOS and Android with home screen installation.
  Use when setting up manifest, service worker, viewport lock, or standalone mode.
---

# PWA Mobile App

Setup for web as fullscreen mobile application with home screen installation.

## Meta Tags
```html
<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
<meta name="mobile-web-app-capable" content="yes">
<meta name="theme-color" content="[PRIMARY_COLOR]">
<meta name="apple-mobile-web-app-capable" content="yes">
<meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">
<meta name="apple-mobile-web-app-title" content="[APP_NAME]">
<link rel="apple-touch-icon" href="/assets/icons/apple-touch-icon-180.png">
<link rel="manifest" href="/manifest.json">
```

## manifest.json
```json
{
  "id": "/",
  "name": "[FULL_APP_NAME]",
  "short_name": "[APP_NAME]",
  "description": "[APP_DESCRIPTION]",
  "start_url": "/",
  "scope": "/",
  "display": "standalone",
  "background_color": "[BG_COLOR]",
  "theme_color": "[PRIMARY_COLOR]",
  "prefer_related_applications": false,
  "icons": [
    { "src": "/assets/icons/icon-192.png", "sizes": "192x192", "type": "image/png" },
    { "src": "/assets/icons/icon-512.png", "sizes": "512x512", "type": "image/png" },
    { "src": "/assets/icons/icon-maskable-512.png", "sizes": "512x512", "purpose": "maskable" }
  ],
  "shortcuts": []
}
```
CRITICAL: `id` property ensures stable PWA identity.

## Fullscreen Lock

> [!CAUTION]
> PWA = fullscreen app. NO zoom, NO bounce, NO viewport resize.

### Required
- Viewport: `maximum-scale=1.0, user-scalable=no` (already in Meta Tags)
- CSS: `touch-action: pan-y` on body (blocks pinch zoom)
- JS: `gesturestart` + `gesturechange` prevention (Safari iOS)

```javascript
document.addEventListener('gesturestart', e => e.preventDefault());
document.addEventListener('gesturechange', e => e.preventDefault());
```

## CSS
```css
html, body {
  overflow: hidden;
  overscroll-behavior: none;
}
body {
  -webkit-user-select: none;
  -webkit-touch-callout: none;
  -webkit-tap-highlight-color: transparent;
  touch-action: pan-y;
  background-color: [BG_COLOR]; /* iOS 26+ reads for status bar */
}
.app-container {
  padding-top: env(safe-area-inset-top);
  padding-bottom: env(safe-area-inset-bottom);
  height: 100vh;
  overflow-y: auto;
  -webkit-overflow-scrolling: touch;
}
```

iOS TRAP: DO NOT use `position: fixed; inset: 0` on root — breaks status bar blending. Use native scroll inside app-container.

## iOS specifics
- Manual installation (Safari -> Share -> Add to Home Screen)
- Push notifications iOS 16.4+ (requires Add to Home Screen)
- Limit ~50MB cache, 7 days expiration
- Navigation API: Safari 26.2+

## Service Worker
```javascript
const CACHE_NAME = 'app-v1';
const ASSETS = ['/', '/css/styles.css', '/js/main.js'];
self.addEventListener('install', e => e.waitUntil(caches.open(CACHE_NAME).then(c => c.addAll(ASSETS))));
self.addEventListener('fetch', e => e.respondWith(caches.match(e.request).then(r => r || fetch(e.request))));
```

## Checklist
- manifest.json with `id` property
- Icons: 192, 512, maskable
- Apple meta tags
- Safe areas (env())
- Service Worker
- HTTPS
