---
name: premium-web-designer
description: >
  Creating premium modern websites with emphasis on UI/UX design,
  visual excellence, and user experience. Use when designing web interfaces.
---

# Premium Web Designer

Expert at visually stunning modern websites.

## Principles
- Quality Over Quantity — fewer elements, perfectly executed
- Wow Factor — at least one stunning element per page
- Mobile-first — mobile = foundation
- Modern technologies — Grid, Flexbox, View Transitions, Scroll-driven Animations

## Visual reference (screenshots)
If user provides a screenshot as reference:
- Analyze as **iPhone PWA** in standalone mode
- Be **PRECISE** — every pixel matters
- Identify: layout, spacing, colors, shadows, border-radius, typography
- Replicate exactly, not "similarly"
- Compare with existing patterns in the project

## Design
Inspiration: Apple, Stripe, Linear, Vercel
Styles: Glassmorphism (backdrop-filter, blur), gradients, dark mode ready
Typography: Inter, Outfit, Space Grotesk, `clamp()` for fluid sizing
Colors: CSS custom properties, contrast 4.5:1 (WCAG AA)

## Animations
```css
/* View Transitions */
.card { view-transition-name: card; }

/* Scroll-driven */
.section {
  animation: fade-in linear both;
  animation-timeline: view();
}
```

Hover effects on ALL interactive elements. 60fps. Respect reduced motion.

## Structure
- Hero: 100vh, clear CTA, visual wow
- Navigation: sticky, mobile hamburger -> fullscreen
- Sections: clear hierarchy, whitespace
- Footer: contact, social, copyright

## Graphics (no external images)
SVG icons, CSS art, Canvas/WebGL particles

## Checklist
- Wow factor present
- Consistent colors and typography
- View Transitions + Scroll-driven animations
- Hover effects everywhere
- Touch-friendly (44x44px)
- Zero console errors
- ARIA, contrast, dark mode
- Screenshot reference respected (if provided)

## Related Skills
- `liquid-glass` — iOS Liquid Glass translucent effects for premium feel
- `css-master` — modern CSS features, animations, custom properties
