---
name: liquid-glass
description: >
  iOS 26 Liquid Glass effect for web - translucence, blur, animations. Pure CSS/JS.
  Use when implementing frosted glass, backdrop-filter effects, or glassmorphism.
---

# Liquid Glass - iOS 26 Style

Apple Liquid Glass implementation using pure CSS and JS.

## Key properties
1. Translucence — content shows through
2. Dynamic Blur — `backdrop-filter: blur()`
3. Gradient Borders — subtle edges
4. Motion Response — reacts to movement
5. Depth Layers — multiple layers

## CSS Variables
```css
:root {
  --glass-bg: rgba(255, 255, 255, 0.08);
  --glass-bg-dark: rgba(0, 0, 0, 0.25);
  --glass-blur: 20px;
  --glass-border: rgba(255, 255, 255, 0.15);
  --glass-shadow: 0 8px 32px rgba(0, 0, 0, 0.3);
}
```

## Basic Glass Card
```css
.glass-card {
  background: var(--glass-bg);
  backdrop-filter: blur(var(--glass-blur));
  -webkit-backdrop-filter: blur(var(--glass-blur));
  border: 1px solid var(--glass-border);
  border-radius: 16px;
  box-shadow: var(--glass-shadow), inset 0 1px 0 rgba(255, 255, 255, 0.1);
}
```

## Dark Glass
```css
.glass-dark {
  background: var(--glass-bg-dark);
  backdrop-filter: blur(var(--glass-blur)) saturate(180%);
  -webkit-backdrop-filter: blur(var(--glass-blur)) saturate(180%);
}
```

## Gradient Border
```css
.glass-gradient-border::before {
  content: '';
  position: absolute;
  inset: 0;
  border-radius: inherit;
  padding: 1px;
  background: linear-gradient(135deg, rgba(255,255,255,0.3), rgba(255,255,255,0.05), rgba(255,255,255,0.2));
  -webkit-mask: linear-gradient(#fff 0 0) content-box, linear-gradient(#fff 0 0);
  mask-composite: exclude;
  pointer-events: none;
}
```

## Animated Background
```css
.glass-orb {
  position: absolute;
  border-radius: 50%;
  filter: blur(60px);
  opacity: 0.6;
  animation: float 20s ease-in-out infinite;
}
@keyframes float {
  0%, 100% { transform: translate(0, 0) scale(1); }
  50% { transform: translate(-20px, 20px) scale(0.95); }
}
```

## Safari
ALWAYS both prefixes: `backdrop-filter` + `-webkit-backdrop-filter`

## Fallback
```css
@supports (backdrop-filter: blur(20px)) {
  .glass-card { background: rgba(30, 30, 40, 0.6); backdrop-filter: blur(20px); }
}
```

## Performance
- Limit number of glass elements
- Never animate blur value
- Mobile: reduced blur (12px)
- `@media (prefers-reduced-motion: reduce)` — disable animations

## Checklist
- CSS variables defined
- Safari prefixes
- Fallback for unsupported browsers
- Reduced motion respected
- Mobile optimization
