---
name: css-master
description: >
  Write perfect, modern, and responsive CSS styles. Use when working with
  stylesheets, CSS custom properties, layouts, animations, or component styling.
---

# CSS Master

You are an absolute master of modern CSS. Elegant, responsive styles using the latest features.

## Principles

> [!CAUTION]
> **TAILWIND CSS IS PROHIBITED!** NEVER use Tailwind — no CDN, no utility classes in HTML.
> All styles go into vanilla CSS files.

**PROJECT CSS ARCHITECTURE:**
```
css/
├── utilities/layout.css    # Global utilities (flex, gap, space-y, hidden, mb)
├── base/                   # App shell, header, footer, animations, prose
├── components/             # Sidebar, modal, cards, forms
├── themes.css              # Theme variables (dark/gray/light)
├── components.css          # Shared components (form-input, btn-*)
└── styles.css              # Main styles
```


**MODERN CSS FEATURES.** CSS Nesting, Container Queries, Custom Properties, `clamp()`. Use what browsers support today.

**2026 CSS.** Prefer these when browser support allows:
- `if()` — conditional logic in CSS values
- Anchor Positioning — position elements relative to others without JS
- Scroll-Driven Animations — tie animations to scroll progress
- `sibling-index()` / `sibling-count()` — dynamic sibling calculations
- Container Scroll State Queries — style based on stuck/snapped/scrollable state
- CSS Carousels — `::scroll-marker`, `::scroll-button` pseudo-elements
- `text-box-trim` — precise typographic whitespace trimming
- `contrast-color()` — automatic accessible text color
- Native Masonry Layouts — CSS Grid masonry without JS
- Stylable `<select>` — native dropdown customization
- `@starting-style` — clean enter transitions

**MOBILE FIRST.** Base styles for mobile. Media queries add complexity for larger screens. NEVER desktop-first.

**LOGICAL PROPERTIES.** `inline-size` instead of `width`, `block-size` instead of `height`, `inset` instead of top/right/bottom/left.

**FLUID TYPOGRAPHY.** `clamp(min, preferred, max)` for fonts. No breakpoints for font size.

**CUSTOM PROPERTIES.** Colors, spacing, typography in CSS variables. Single source of truth. NEVER hardcode values.

**MODERN COLORS.** `oklch()` for perceptually uniform colors. `light-dark()` for automatic switching.

**PERFORMANCE ANIMATIONS.** Only `transform` and `opacity`. NEVER width/height/top/left. 60fps minimum.

**NO MAGIC NUMBERS.** Every value has a reason. Spacing from design token. Colors from system.

**MODULAR FILES.** Components in separate files. **See `modular-code.md` for `/css/components/` structure.**

**SCROLLBAR STYLING.** Two levels:
1. **Color/hiding** -> standard CSS: `scrollbar-width` (`auto`/`thin`/`none`) + `scrollbar-color`. Works everywhere.
2. **Custom width** -> standard CSS CANNOT set custom width. Only solution = **custom JS scrollbar** (hide native + DOM track/thumb). Reference: `js/components/custom-scrollbar.js`.

**NEVER `::-webkit-scrollbar`** — Safari on macOS completely ignores it. NOT as fallback, NOT as supplement — simply NEVER.
Hide on mobile via `@media (max-width)`, NOT `pointer: coarse`.

## Visual Reference (screenshots)
If user provides a screenshot as reference:
- Analyze as **iPhone PWA** in standalone mode
- Be **PRECISE** in replication:
  - Exact colors (use color picker)
  - Exact spacing (padding, margin, gap)
  - Exact border-radius, shadows
  - Exact typography (size, weight, line-height)
- Use existing CSS variables from project
- If missing, propose new ones consistent with design

## Mindset
Before every rule: Works on mobile? Modern feature? Value in design system? Animation smooth? Matches reference?

## Result
- Modern — latest CSS features
- Responsive — perfect on all devices
- Maintainable — custom properties, logical structure
- Performant — 60fps animations
- Precise — pixel-perfect to reference

## Related Skills
- `liquid-glass` — iOS Liquid Glass translucent effects (blur, gradients, animations)
- `responsive-design` — breakpoints, fluid typography, mobile-first
