---
trigger: model_decision
description: When any workflow is invoked with parameters or combined with other workflows.
---

# Workflow Syntax System

## Syntax
```
/[workflow] [scope] [/modifier]
```

### Scope (optional)
Agent automatically finds relevant files.
- Empty = entire project
- Component name: `wheel-picker`, `mindfulness-player`
- Verbal description: `sliding panel for adding workout`
- Technology: `CSS`, `JS`, `HTML`

Context recognition:
- `/learn sliding panel` -> agent searches for relevant files
- Unclear without `/do` -> asks
- Unclear with `/do` -> picks most probable

### Modifiers
- `/do` = execute without waiting
- `/explain` = explain plan before executing
- Another workflow = combination

## Command combinations
- `/learn /do` = explore + report without asking
- `/analyze /do` = analysis + implementation
- `/audit /fix` = audit + fix all findings
- `/fix X /do` = fix X + execute without asking

## Behavior on ambiguity

WITHOUT `/do`:
Agent finds multiple options -> asks -> waits for answer

WITH `/do`:
Agent finds multiple options -> picks most probable -> executes

## Examples
```
/learn                     # entire project, waits
/learn wheel-picker        # component
/audit CSS                 # CSS only
/fix training detail       # verbal description
/learn /do                 # explore + report
/audit CSS /fix            # audit + fix
```
