---
trigger: always_on
description: When working with HTML, CSS, JS, or web development in general.
---

# Web Development Standards

> [!CAUTION]
> **TAILWIND CSS IS PROHIBITED!** The project uses exclusively vanilla CSS (modular architecture).
> NEVER use Tailwind utility classes (`flex`, `bg-*`, `text-*`, `p-*` etc.) in HTML.
> Styles belong in CSS files: `css/base/`, `css/components/`, `css/utilities/`.


## 1. Project Structure
```
/
├── index.html            # Main shell (<300 lines)
├── /templates            # HTML views (SPA)
├── /css
│   ├── styles.css
│   └── components/
├── /js
│   ├── main.js
│   ├── /modules
│   └── /components
└── /assets
    ├── /images
    └── /icons
```

NEVER put multiple views into index.html:
- index.html = only shell
- Views in `/templates/*.html`
- Router loads via `fetch()`
- Add to Service Worker cache

## 2. Zero Build — FTP Ready
- No bundlers, no transpilation
- CDN for libraries
- ALWAYS USE RELATIVE PATHS: `./css/`, `./js/`, `./assets/`
- NEVER absolute: `/css/`, `/js/`

## 3. Modularity & DRY

> [!NOTE]
> See `modular-code.md` rule (always ON) for complete modular architecture principles.

**Web-specific:**
- Shared components in `/js/components/[name].js`
- Render functions return HTML string
- Export: `export function initComponent(containerId, options)`

## 4. Code Quality
- HTML5 semantic tags, ARIA
- CSS custom properties
- JS ES6+, `type="module"`, no globals
- Console: zero errors

## 5. Mobile First
- Viewport `width=device-width, initial-scale=1.0`
- Touch-friendly min 44x44px
- Breakpoints: 640/768/1024/1280px
- Container Queries for components

### Fullscreen Mobile App
→ See skill `pwa-mobile-app` for viewport lock, touch prevention, and safe areas.

## 6. Modern CSS
- CSS Nesting, Container Queries
- Fluid Typography: `clamp()`
- View Transitions
- Scroll-driven Animations
- Logical Properties
- Anchor Positioning, Popover API
- `oklch()`, `light-dark()`
- `content-visibility: auto` for rendering performance
- `contrast-color()` for accessible text on any background

## 7. Modern JS (ES2026+)
- `using` / `await using` — automatic resource cleanup (Explicit Resource Management)
- `Promise.withResolvers()` — create promise + resolve/reject externally
- `Object.groupBy()` / `Map.groupBy()` — native grouping
- `RegExp.escape()` — safe regex from user input
- Temporal API — modern date/time (when baseline, replaces Date)

## 8. Performance
- CSS: critical inline, rest async
- JS: defer/async, `type="module"`
- Images: lazy loading, WebP/AVIF
- Animations: `transform` + `opacity`
- Fonts: `font-display: swap`, preload

## 9. Scrollbar Styling
→ See skill `css-master` for complete scrollbar rules (standard CSS, Safari compat, custom JS scrollbar).

## 10. AI Integration
→ See rule `ai-api.md` for LLM/TTS API integration (PHP proxy, streaming, tools).