---
trigger: model_decision
description: When working with icons -- adding to HTML, creating SVG, editing existing, working with assets/icons/
---

# SVG Icon System

NEVER add SVG path directly into HTML.
NEVER use `<img src="*.svg">`.

## How the system works
1. Icons are files in `assets/icons/*.svg`
2. `main.js` loads all at startup using `loadSvgIcons()`
3. Creates `<symbol id="icon-{name}">` for each
4. In HTML use `<use href="#icon-name">`

## CORRECT
```html
<svg width="24" height="24"><use href="#icon-x"></use></svg>
<svg width="20" height="20"><use href="#icon-check"></use></svg>
```

## WRONG
```html
<svg><path d="M18 6L6 18" /></svg>
<img src="assets/icons/check.svg">
```

## Adding a new icon
1. Create `assets/icons/{name}.svg` (use skill `svg-master`)
   - For interactive testing use `/icon-test {name}`
2. Register in `js/main.js` -> `loadSvgIcons()` -> `icons` array
3. Add to cache in `sw.js` -> `STATIC_ASSETS` array
4. Use: `<svg width="24" height="24"><use href="#icon-{name}"></use></svg>`

## SVG file format
```xml
<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" 
     stroke="currentColor" stroke-width="2" stroke-linecap="round" 
     stroke-linejoin="round">
  <!-- paths -->
</svg>
```