---
trigger: always_on
description: When deploying, configuring, managing, or administering the remote server — SSH commands, file uploads, database operations, server maintenance. Any task the user would otherwise have to do manually on the server.
---

# SSH Server Operations

> [!CAUTION]
> **The user NEVER has to do ANYTHING on the server. EVER.**
> Every server operation — deploy, DB migration, config change, file edit, log check, restart — is YOUR responsibility.
> If a task requires server action, YOU execute it via SSH. Do not ask the user to SSH in.

## Server

| Key | Value |
|-----|-------|
| HOST | `hosting.pilsfree.net` |
| USER | `chudy` |
| AUTH | SSH key (no password) |
| HOME | `/home/chudy/` |
| WEB ROOT | `/home/chudy/public_html/{PROJECT_NAME}/` |

`{PROJECT_NAME}` = basename of current workspace directory.

## Core Principle

**You are the server administrator.** The user works locally. You handle everything remote:

- **Deploy code** → `rsync`
- **Run SQL** → `ssh ... "mysql ..."`
- **Edit server files** → `ssh ... "sed/cat/echo ..."`
- **Check logs** → `ssh ... "tail ..."`
- **Manage files** → `ssh ... "ls/rm/mv/chmod ..."`
- **Import data** → pipe via SSH: `cat file.sql | ssh ... "mysql ..."`

## SSH Command Patterns

### Single command
```bash
ssh chudy@hosting.pilsfree.net "command"
```

### Multi-line / complex
```bash
ssh chudy@hosting.pilsfree.net << 'EOF'
command1
command2
EOF
```

### Pipe local file to remote
```bash
cat local_file.sql | ssh chudy@hosting.pilsfree.net "mysql -u chudy -pfE9km3eekS users_chudy1"
```

### Deploy (rsync)
```bash
rsync -avz --delete --exclude='data/' {LOCAL_PATH}/ chudy@hosting.pilsfree.net:/home/chudy/public_html/{PROJECT_NAME}/
```

## SQL via SSH

See skill `sql-mariadb` for connection details. Execute SQL on server:

```bash
ssh chudy@hosting.pilsfree.net "mysql -u chudy -pfE9km3eekS {DB_NAME} -e 'SQL_QUERY'"
```

For complex SQL (schema changes, data import):
```bash
cat schema.sql | ssh chudy@hosting.pilsfree.net "mysql -u chudy -pfE9km3eekS {DB_NAME}"
```

## Rules

1. **ALWAYS execute server tasks yourself** — never delegate to user
2. **Verify after every change** — check the result via SSH or curl
3. **Use `--dry-run`** on destructive rsync operations first if uncertain
4. **Quote SQL** carefully in SSH — use heredoc or pipe for complex queries
5. **Log what you did** — tell the user what commands ran and their results