---
trigger: model_decision
description: When testing, deploying, debugging, or verifying code changes — SSH deployment, curl API testing, remote server workflow.
---

# Remote Testing & Deployment

> [!CAUTION]
> **NO local testing!** All testing happens on the remote server via SSH deploy + curl.
> - **DO NOT** run local dev servers (`npm run dev`, `php -S`, `python -m http.server`)
> - **DO NOT** open the browser (`browser_subagent`)
> - **DO NOT** test PHP locally

## Server Configuration

| Key | Value |
|-----|-------|
| HOST | `hosting.pilsfree.net` |
| USER | `chudy` |
| REMOTE_PATH | `/home/chudy/public_html/{PROJECT_NAME}/` |
| LOCAL_PATH | *(auto from workspace URI)* |
| BASE_URL | `http://hosting.pilsfree.net/chudy/{PROJECT_NAME}/` |
| AUTH | SSH key (stored in system) |

## Workflow

### 1. Deploy via rsync
```bash
rsync -avz --delete \
  --exclude '.git' \
  --exclude '.agent' \
  --exclude 'node_modules' \
  --exclude 'docs' \
  {LOCAL_PATH}/ chudy@hosting.pilsfree.net:/home/chudy/public_html/{PROJECT_NAME}/
```

### 2. Test API via curl
```bash
# GET endpoint
curl -s http://hosting.pilsfree.net/chudy/{PROJECT_NAME}/api/endpoint.php | jq .

# POST endpoint
curl -s -X POST \
  -H "Content-Type: application/json" \
  -d '{"key": "value"}' \
  http://hosting.pilsfree.net/chudy/{PROJECT_NAME}/api/endpoint.php | jq .

# With verbose output for debugging
curl -v http://hosting.pilsfree.net/chudy/{PROJECT_NAME}/api/endpoint.php
```

### 3. Check server logs (if needed)
```bash
ssh chudy@hosting.pilsfree.net "tail -20 /home/chudy/public_html/{PROJECT_NAME}/api/error.log"
```

## Rules

1. **After every code change** — deploy via rsync, then test via curl
2. **API debugging** — always use curl with `-s` and pipe to `jq .`
3. **Never assume** — verify the response matches expected format
4. **Error investigation** — check server error logs via SSH
5. **Frontend testing** — only the USER tests in browser

## Related

- **Rule** `ssh-server-operations` → full SSH server admin (always-on)
- **Workflow** `/deploy` → rsync + Safari reload
- **Workflow** `/ssh-sql` → SQL operations on server