---
trigger: model_decision
description: When working with JS/PHP code — every action must log to Live Console.
---

# Live Console Logging

> [!CAUTION]
> **EVERY action in the project MUST log to Live Console!**
> Without logs = incomplete implementation.

## Rule

When writing/editing code that:
- Calls API (fetch, cURL)
- Processes data (filtering, parsing, validation)
- Changes state (save, delete, update)
- Communicates with server (HTTP, WebSocket)

-> **MUST log to Live Console** — step-by-step, with result.

## How to log

### JavaScript
```javascript
import { log, logApiSteps } from './console.js';

log('Message', 'info');     // gray — general info
log('Message', 'step');     // cyan — progress step
log('Message', 'success');  // green — completion
log('Message', 'error');    // red — error
log('Message', 'warn');     // yellow — warning
```

### PHP (backend -> frontend)
```php
$logs[] = ['step' => 'step_name', 'message' => 'Detailed message'];
// Return in response: 'logs' => $logs
// On frontend: logApiSteps(response.logs)
```

## What to log
- **Before action:** what is about to happen (`Connecting to API...`, `Loading models...`)
- **Network:** DNS, HTTP status, timing, size
- **Result:** counts, IDs, status
- **Errors:** always with details

## Reference
- Core: `js/admin/console.js`
- Feature doc: `docs/features/001-live-console.md`