---
trigger: model_decision
description: When generating images using the generate_image tool
---

# Image Generation Standards

When generating images ALWAYS:
- Use skill `image-generator`
- Get colors from `css/tokens.css`
- Plan for 1:1 output with subsequent crop

## Required prompt elements
- Background: exact HEX from tokens.css
- Composition: placement for subsequent crop
- Style: consistent with the project
- Format: 1:1 output, then PIL crop + WebP

## Set consistency
1. First image = define the style
2. Next = provide previous as reference
3. Describe only changes, style stays

## Post-processing
```python
from PIL import Image
img = Image.open("source.png")
# Crop to 16:9 from center
width, height = img.size
new_height = width * 9 // 16
top = (height - new_height) // 2
cropped = img.crop((0, top, width, top + new_height))
cropped.save("output.webp", "WEBP", quality=85)
```

## PROHIBITED
- Generating without knowing project colors
- Placeholder backgrounds
- Ignoring target aspect ratio
- Set without reference to previous image
