---
trigger: model_decision
description: After implementing/modifying functionality -- reminds to offer feature documentation creation/update.
---

# Feature Documentation Prompt

After completing implementation or modification of functionality, **ALWAYS ask**:

> Should I create/update the corresponding `/feature` document?

## Rules

### 1. When to ask
- After completing new functionality
- After significant modification of existing functionality
- After refactoring that changes architecture or interfaces

### 2. How to identify the feature
- Check `docs/features/` -- does a document exist for this functionality?
  - **Yes** -> offer UPDATE
  - **No** -> offer CREATE

### 3. Mandatory flow (NEVER skip)

```
Implementation -> Offer /feature -> User tests -> User confirms
-> ONLY THEN create/update documentation
```

> [!CAUTION]
> **NEVER update or create feature documentation without explicit confirmation
> from the user that the implementation works correctly after their test.**
> The user must test and confirm first -- only then document.

### 4. What to say to the user
Example after implementation:

```
Implementation done. Want to test and then update /feature documentation?
```

### 5. Exceptions -- when NOT to ask
- Trivial fixes (typos, formatting)
- Changes outside feature scope (config, tooling)
- User explicitly says they don't want documentation
