---
trigger: model_decision
description: When creating or editing agent configuration — rules, skills, workflows in .agent/ directory
---

# Config Standards

When creating configuration ALWAYS:
- Use skill `config-creator`
- Check that a similar one does not already exist
- Follow the style of existing files

## Structure
- Rule: `.agent/rules/[name].md`
- Skill: `.agent/skills/[name]/SKILL.md`
- Workflow: `.agent/workflows/[name].md`

## Required elements

### Rule
- Activation mode set via **UI** (Always On, Manual, Model Decision, Glob)
- `trigger:` and `description:` may be added in YAML frontmatter for documentation
- Max 12,000 characters
- Supports `@filename` references to other files

### Skill
- Folder + `SKILL.md` with YAML frontmatter
- `name:` — skill identifier
- `description:` — clear, detailed description with "Use when..." pattern and keywords for agent discovery
- Role description in first person ("You are...")
- Progressive disclosure: only `description` loaded initially, full SKILL.md loaded on activation

### Workflow
- `description:` — short description in YAML frontmatter
- Invoked via `/workflow-name` slash command
- Numbered steps with clear actions
- Max 12,000 characters

## PROHIBITED
- Empty or vague description
- TODO or placeholder content
- Duplicate configuration
- Non-existent references
- `trigger:` field in skill YAML frontmatter — use `description:` for discovery keywords
