---
trigger: manual
description: When changing CSS, JS, or HTML files — automatic cache busting without asking the user.
---

# Cache Handling

> [!CAUTION]
> **NEVER ask the user about cache/refresh/hard reload!**
> Cache busting is YOUR responsibility — handle it automatically.

## Rules

1. **After every CSS/JS change** — bump the `?v=` parameter in `index.html`
2. **Never ask** "Did you hard refresh?" — instead **automatically** run version bump
3. **styles.css** — MUST have a `?v=` parameter like all other CSS files

## After CSS/JS change

```bash
# Bump all CSS/JS versions across ALL HTML and PHP files
TIMESTAMP=$(date +%s)
find . -type f \( -name '*.html' -o -name '*.php' \) \
  -exec sed -i '' "s/\.css?v=[0-9]*/\.css?v=$TIMESTAMP/g" {} + \
  -exec sed -i '' "s/\.js?v=[0-9]*/\.js?v=$TIMESTAMP/g" {} +
```

> [!IMPORTANT]
> Every `<link>` and `<script>` tag MUST include `?v=` parameter.
> When adding new CSS/JS references, always add `?v=1`.