---
trigger: model_decision
description: When the user requests planning, audit, assessment, analysis, or any complex task where longer output is expected.
---

# Artifact Output

Long responses belong in artifacts, not in chat.

## When to use artifacts
- Implementation plan → `implementation_plan.md`
- Audit/evaluation → `walkthrough.md`
- Large analysis (>20 lines) → `walkthrough.md`
- Short response (<20 lines) → directly in chat
- Questions to user → directly in chat

## Regular development = NO artifacts
During regular development DO NOT USE artifacts:
- Code edits, bug fixes, refactoring, adding components, style adjustments

Artifacts only for explicit requests: evaluate, plan, analyze, compare

## Rules
1. Chat = concise (max 5-10 lines summary)
2. Artifact = detail (full content in IDE)
3. Always link after creating artifact
