---
trigger: model_decision
description: When integrating AI APIs — LLM chat completion, streaming, tools/function calling, agent loops, TTS/text-to-speech, voice synthesis, structured output, provider selection, voice cloning.
---

# AI API Integration

## Rules

1. **API keys ONLY in PHP** — never expose to frontend JavaScript
2. **PHP proxy** for all AI API calls — JS `fetch()` → PHP cURL → provider
3. **Streaming** uses `ReadableStream` + `getReader()` — NOT `EventSource`
4. **Always provide `AbortController`** for cancel capability
5. **Agent loop max iterations** — prevent infinite tool calling loops
6. **XSS sanitize** all LLM output before DOM insertion
7. **Retry with exponential backoff** for API errors (429, 500, 503)

## Required Skills

### LLM Providers
- `ai-api` — complete implementation patterns (LLM + TTS)
- `openai-api-dev` — OpenAI models, endpoints, tool calling
- `anthropic-api-dev` — Anthropic Claude, Messages API (non-OpenAI format)
- `gemini-api-dev` — Gemini models, multimodal, SDK
- `mistral-api-dev` — Mistral models, Codestral, Agents API
- `groq-api-dev` — Groq ultra-fast LPU inference, OpenAI-compatible
- `openrouter-api-dev` — OpenRouter unified proxy, 500+ models

### TTS Providers
- `tts-voice-instructor` — TTS voice instructions (OpenAI gpt-4o-mini-tts)
- `elevenlabs-tts` — ElevenLabs TTS (v3, Flash, voice cloning)
- `cartesia-tts` — Cartesia Sonic TTS (ultra-low latency)
- `fish-audio-tts` — Fish Audio TTS (S1, emotion markers)
- `playht-tts` -- PlayHT TTS (Play3.0, PlayDialog, 900+ voices)

### Supporting
- `system-prompt-master` — prompt engineering
- `sql-mariadb` — MariaDB storage (future)

## Data Storage
- **Current**: JSON files in `data/` directory
- **Future**: MariaDB tables (see skill `sql-mariadb`)

## Web Dev Standards
→ See rule `web-dev-standards.md` for HTML/CSS/JS project structure and conventions.

