from urllib.parse import quote_plus

# --- Barevná paleta pro kontextové menu (AARRGGBB formát) ---
COLOR_DETAIL = "FF00EFFF"      # Světle modrá/azurová – detailní okno / informace
COLOR_MILIONAR = "FFFFD700"    # Zlatá – Milionář (hlavní název)
COLOR_ADD_MY = "FF32CD32"      # Zelená – Přidat do Moje seriály/filmy
COLOR_ADD_LIBRARY = "FFFFA500" # Oranžová – Přidat do knihovny Kodi
COLOR_DELETE = "FFFF4500"      # Červená – Smazat seriál/film
COLOR_PLAY = "FF00FF00"        # Zelená – PŘEHRÁT IHNED
COLOR_PLAY_OUTLINE = "FFD3D3D3"# Šedý obrys pro bílou
COLOR_SIMILAR = "FF9370DB"     # Fialová – Podobné filmy / Zobrazit kolekci
COLOR_COLLECTION = "FFBA55FF"  # Světle fialová – Zobrazit kolekci
COLOR_QUEUE = "FFA9A9A9"       # Šedá – Zařadit do fronty / Označit jako zhlédnuté

# --- Konec barevné palety ---

# --- Všechny funkce pro menu používají čistý text z lokalizace, ale nyní obalují barvou ---
def create_movie_context_menu(addon, tmdb_id, title, year, plot, poster, is_in_my_movies=False, original_title=None):
    safe_title = quote_plus(str(title or ''))
    safe_year = quote_plus(str(year or ''))
    safe_plot = quote_plus(str(plot or ''))
    safe_poster = quote_plus(str(poster or ''))
    safe_original_title = quote_plus(str(original_title or title or ''))
    plugin_base_url = f"plugin://{addon.getAddonInfo('id')}"
    commands = []
    commands.append((f"[COLOR {COLOR_SIMILAR}]{addon.getLocalizedString(32120)}[/COLOR]", f"Container.Update({plugin_base_url}?action=show_similar_movies&tmdb_id={tmdb_id}&original_title={safe_original_title})"))
    commands.append((f"[COLOR {COLOR_COLLECTION}]{addon.getLocalizedString(32121)}[/COLOR]", f"Container.Update({plugin_base_url}?action=show_movie_collection&tmdb_id={tmdb_id})"))
    commands.append((f"[COLOR {COLOR_DETAIL}]{addon.getLocalizedString(32114)}[/COLOR]", f"RunPlugin({plugin_base_url}?action=show_wcs_details&media_type=movie&tmdb_id={tmdb_id})"))
    commands.append((f"[COLOR {COLOR_PLAY}]{addon.getLocalizedString(30060)}[/COLOR]", f"RunPlugin({plugin_base_url}?action=play_movie_from_addon&title={safe_title}&year={safe_year}&plot={safe_plot}&poster={safe_poster}&tmdb_id={tmdb_id})"))
    commands.append((f"[COLOR {COLOR_MILIONAR}]{addon.getLocalizedString(32124)}[/COLOR]", f"RunPlugin({plugin_base_url}?action=play_text_game&media_type=movie&tmdb_id={tmdb_id}&title={safe_title}&plot={safe_plot}&poster={safe_poster})"))
    commands.append((f"[COLOR {COLOR_ADD_MY}]{addon.getLocalizedString(32115)}[/COLOR]", f"RunPlugin({plugin_base_url}?action=tmdb_add_movie_to_list&tmdb_id={tmdb_id}&title={safe_title})"))
    commands.append((f"[COLOR {COLOR_ADD_LIBRARY}]{addon.getLocalizedString(32117)}[/COLOR]", f"RunPlugin({plugin_base_url}?action=check_library_settings_and_add&media_type=movie&movie_id={tmdb_id})"))
    return commands

def create_my_movies_context_menu(addon, tmdb_id, title, year=None, plot=None, poster=None, idx=None):
    """Sestaví kontextové menu pro filmy v 'Moje filmy'."""
    safe_title = quote_plus(str(title or ''))
    safe_year = quote_plus(str(year or ''))
    safe_plot = quote_plus(str(plot or ''))
    safe_poster = quote_plus(str(poster or ''))
    safe_original_title = quote_plus(str(title or ''))
    
    plugin_base_url = f"plugin://{addon.getAddonInfo('id')}"
    
    commands = [
        (f"[COLOR {COLOR_SIMILAR}]{addon.getLocalizedString(32120)}[/COLOR]", f"Container.Update({plugin_base_url}?action=show_similar_movies&tmdb_id={tmdb_id}&original_title={safe_original_title})"),
        (f"[COLOR {COLOR_COLLECTION}]{addon.getLocalizedString(32121)}[/COLOR]", f"Container.Update({plugin_base_url}?action=show_movie_collection&tmdb_id={tmdb_id})"),
        (f"[COLOR {COLOR_DETAIL}]{addon.getLocalizedString(32114)}[/COLOR]", f"Container.Update({plugin_base_url}?action=show_wcs_details&media_type=movie&tmdb_id={tmdb_id})"),
        (f"[COLOR {COLOR_PLAY}]{addon.getLocalizedString(30060)}[/COLOR]", f"RunPlugin({plugin_base_url}?action=play_movie_from_addon&title={safe_title}&year={safe_year}&plot={safe_plot}&poster={safe_poster}&tmdb_id={tmdb_id})"),
        (f"[COLOR {COLOR_MILIONAR}]{addon.getLocalizedString(32124)}[/COLOR]", f"RunPlugin({plugin_base_url}?action=play_text_game&media_type=movie&tmdb_id={tmdb_id}&title={safe_title}&plot={safe_plot}&poster={safe_poster})"),
        (f"[COLOR {COLOR_ADD_LIBRARY}]{addon.getLocalizedString(32117)}[/COLOR]", f"RunPlugin({plugin_base_url}?action=check_library_settings_and_add&media_type=movie&movie_id={tmdb_id})"),
    ]
    
    # Přidání položky pro odstranění filmu (pokud je poskytnut idx)
    if idx is not None:
        commands.append((f"[COLOR {COLOR_DELETE}]{addon.getLocalizedString(32118)}[/COLOR]", f"RunPlugin({plugin_base_url}?action=tmdb_movie_remove&idx={idx})"))
    
    return commands

def create_series_context_menu(addon, tmdb_id, name, year=None, plot=None, poster=None, is_in_my_series=False, original_name=None):
    safe_name = quote_plus(str(name or ''))
    safe_plot = quote_plus(str(plot or ''))
    safe_poster = quote_plus(str(poster or ''))
    
    commands = [
        (f"[COLOR {COLOR_DETAIL}]{addon.getLocalizedString(32114)}[/COLOR]",
         f"Container.Update(plugin://{addon.getAddonInfo('id')}?action=show_wcs_details&media_type=tv&tmdb_id={tmdb_id})"),
        (f"[COLOR {COLOR_MILIONAR}]{addon.getLocalizedString(32124)}[/COLOR]", f"RunPlugin(plugin://{addon.getAddonInfo('id')}?action=play_text_game&media_type=tv&tmdb_id={tmdb_id}&title={safe_name}&plot={safe_plot}&poster={safe_poster})"),
        (f"[COLOR {COLOR_ADD_MY}]{addon.getLocalizedString(32116)}[/COLOR]", f"RunPlugin(plugin://{addon.getAddonInfo('id')}?action=tmdb_add_series_to_list&tmdb_id={tmdb_id}&name={safe_name})"),
        (f"[COLOR {COLOR_ADD_LIBRARY}]{addon.getLocalizedString(32117)}[/COLOR]", f"RunPlugin(plugin://{addon.getAddonInfo('id')}?action=check_library_settings_and_add&media_type=series&series_id={tmdb_id})"),
    ]  
    
    return commands

def create_my_series_context_menu(addon, tmdb_id, name, plot=None, poster=None, idx=None):
    """Sestaví kontextové menu pro seriály v 'Moje seriály'."""
    safe_name = quote_plus(str(name or ''))
    safe_plot = quote_plus(str(plot or ''))
    safe_poster = quote_plus(str(poster or ''))
    
    commands = [
        (f"[COLOR {COLOR_DETAIL}]{addon.getLocalizedString(32114)}[/COLOR]", f"Container.Update(plugin://{addon.getAddonInfo('id')}?action=show_wcs_details&media_type=tv&tmdb_id={tmdb_id})"),
        (f"[COLOR {COLOR_MILIONAR}]{addon.getLocalizedString(32124)}[/COLOR]", f"RunPlugin(plugin://{addon.getAddonInfo('id')}?action=play_text_game&media_type=tv&tmdb_id={tmdb_id}&title={safe_name}&plot={safe_plot}&poster={safe_poster})"),
        (f"[COLOR {COLOR_ADD_LIBRARY}]{addon.getLocalizedString(32117)}[/COLOR]", f"RunPlugin(plugin://{addon.getAddonInfo('id')}?action=check_library_settings_and_add&media_type=series&series_id={tmdb_id})"),
    ]
    
    # Přidání položky pro odstranění seriálu (pokud je poskytnut idx)
    if idx is not None:
        commands.append((f"[COLOR {COLOR_DELETE}]{addon.getLocalizedString(32119)}[/COLOR]", f"RunPlugin(plugin://{addon.getAddonInfo('id')}?action=tmdb_series_remove&idx={idx})"))
    
    return commands

def create_episode_context_menu(addon, series_tmdb_id, series_name, episode_title, season_number, episode_number, plot=None, poster=None):
    """Sestaví standardní seznam příkazů pro kontextové menu epizody."""
    safe_series_name = quote_plus(str(series_name or ''))
    safe_episode_title = quote_plus(str(episode_title or ''))
    safe_plot = quote_plus(str(plot or ''))
    safe_poster = quote_plus(str(poster or ''))
    
    commands = []
    plugin_base_url = f"plugin://{addon.getAddonInfo('id')}"
    
    commands.append((f"[COLOR {COLOR_MILIONAR}]{addon.getLocalizedString(32124)}[/COLOR]", 
        f"RunPlugin({plugin_base_url}?action=play_text_game&media_type=series&tmdb_id={series_tmdb_id}&title={safe_series_name}&plot={safe_plot}&poster={safe_poster}&episode_title={safe_episode_title}&season_number={season_number}&episode_number={episode_number})"))
    
    return commands

def create_favorite_actor_context_menu(addon, actor_id, name, biography=None, profile_url=None, idx=None):
    """Sestaví kontextové menu pro oblíbené herce."""
    safe_name = quote_plus(str(name or ''))
    safe_biography = quote_plus(str(biography or ''))
    safe_profile_url = quote_plus(str(profile_url or ''))
    
    plugin_base_url = f"plugin://{addon.getAddonInfo('id')}"
    
    commands = [
        (f"[COLOR {COLOR_DETAIL}]{addon.getLocalizedString(30649)}[/COLOR]", f"Container.Update({plugin_base_url}?action=tmdb_search_actor_movies&actor_id={actor_id}&actor_name={safe_name})"),
        (f"[COLOR {COLOR_DELETE}]{addon.getLocalizedString(30650)}[/COLOR]", f"RunPlugin({plugin_base_url}?action=tmdb_remove_favorite_actor&idx={idx})"),
        (f"[COLOR {COLOR_MILIONAR}]{addon.getLocalizedString(32124)}[/COLOR]", f"RunPlugin({plugin_base_url}?action=play_text_game&media_type=actor&tmdb_id={actor_id}&title={safe_name}&plot={safe_biography}&poster={safe_profile_url})")
    ]
    
    return commands

def create_favorite_director_context_menu(addon, director_id, name, biography=None, profile_url=None, idx=None):
    """Sestaví kontextové menu pro oblíbené režiséry."""
    safe_name = quote_plus(str(name or ''))
    safe_biography = quote_plus(str(biography or ''))
    safe_profile_url = quote_plus(str(profile_url or ''))
    
    plugin_base_url = f"plugin://{addon.getAddonInfo('id')}"
    
    commands = [
        (f"[COLOR {COLOR_DETAIL}]{addon.getLocalizedString(30657)}[/COLOR]", f"Container.Update({plugin_base_url}?action=tmdb_search_director_movies&director_id={director_id}&director_name={safe_name})"),
        (f"[COLOR {COLOR_DELETE}]{addon.getLocalizedString(30658)}[/COLOR]", f"RunPlugin({plugin_base_url}?action=tmdb_remove_favorite_director&idx={idx})"),
        (f"[COLOR {COLOR_MILIONAR}]{addon.getLocalizedString(32124)}[/COLOR]", f"RunPlugin({plugin_base_url}?action=play_text_game&media_type=director&tmdb_id={director_id}&title={safe_name}&plot={safe_biography}&poster={safe_profile_url})")
    ]
    
    return commands

def create_favorite_writer_context_menu(addon, writer_id, name, biography=None, profile_url=None, idx=None):
    """Sestaví kontextové menu pro oblíbené scénáristy."""
    safe_name = quote_plus(str(name or ''))
    safe_biography = quote_plus(str(biography or ''))
    safe_profile_url = quote_plus(str(profile_url or ''))
    
    plugin_base_url = f"plugin://{addon.getAddonInfo('id')}"
    
    commands = [
        (f"[COLOR {COLOR_DETAIL}]{addon.getLocalizedString(30665)}[/COLOR]", f"Container.Update({plugin_base_url}?action=tmdb_search_writer_movies&writer_id={writer_id}&writer_name={safe_name})"),
        (f"[COLOR {COLOR_DELETE}]{addon.getLocalizedString(30666)}[/COLOR]", f"RunPlugin({plugin_base_url}?action=tmdb_remove_favorite_writer&idx={idx})"),
        (f"[COLOR {COLOR_MILIONAR}]{addon.getLocalizedString(32124)}[/COLOR]", f"RunPlugin({plugin_base_url}?action=play_text_game&media_type=writer&tmdb_id={writer_id}&title={safe_name}&plot={safe_biography}&poster={safe_profile_url})")
    ]
    
    return commands

def create_recently_played_context_menu(addon, idx=None, media_type=None, series_name=None, season=None, episode=None, year=None, poster=None, tmdb_id=None):
    """Sestaví kontextové menu pro naposledy přehrané položky."""
    plugin_base_url = f"plugin://{addon.getAddonInfo('id')}"
    
    commands = []
    
    # Přidání položky pro přehrání dalšího dílu (pouze pro seriály)
    if media_type == 'series' and series_name and season is not None and episode is not None:
        safe_series_name = quote_plus(str(series_name or ''))
        # Nová funkce vyhledá tmdb_id z názvu seriálu pokud není předáno
        tmdb_param = f"&tmdb_id={tmdb_id}" if tmdb_id else ""
        commands.append((
            f"[COLOR {COLOR_PLAY}]Přehrát další epizodu[/COLOR]",
            f"RunPlugin({plugin_base_url}?action=play_next_episode_with_metadata"
            f"&series_name={safe_series_name}"
            f"&current_season={season}"
            f"&current_episode={episode}"
            f"{tmdb_param})"
        ))
    
    # Přidání položky pro odstranění z historie (pokud je poskytnut idx)
    if idx is not None:
        commands.append((f"[COLOR {COLOR_DELETE}]Smazat z historie[/COLOR]", f"RunPlugin({plugin_base_url}?action=remove_recently_played_item\u0026idx={idx})"))
    
    return commands