#!/usr/bin/env python3
"""Generate a rounded rectangle for thin list item focus."""
from PIL import Image, ImageDraw

# Create a thin rounded rectangle for list items
# Full height radius creates a "pill" shape
width, height = 100, 40
radius = 20  # Half of height for pill shape

img = Image.new('RGBA', (width, height), (0, 0, 0, 0))
draw = ImageDraw.Draw(img)

# Draw rounded rectangle (white fill)
draw.rounded_rectangle(
    [(0, 0), (width - 1, height - 1)],
    radius=radius,
    fill=(255, 255, 255, 255)
)

# Save
output_path = '/Users/chudy/Library/Application Support/Kodi/addons/plugin.video.milionar/resources/media/list_focus_rounded.png'
img.save(output_path, 'PNG')
print(f"Saved: {output_path}")
