---
name: kodi-texture-generator
description: Programatické generování masek a textur pomocí PIL/Pillow. Použij pro vytváření rounded corners, pill shapes, scrollbarů a dalších geometrických UI prvků v Python kódu. NEPOUŽÍVEJ pro generování fotografií nebo komplexní grafiky.
trigger: pil_mask, rounded_corners, pill_shape, scrollbar_texture, alpha_mask, generate_texture_code, python_image
---

# Kodi Texture Generator (PIL)

## Kdy použít
- Vytváření **masek** pro zaoblené rohy
- Generování **geometrických tvarů** (pill, rounded rect, scrollbar)
- Programatické textury s **průhledností** (alpha channel)
- Kód v Python používající **PIL/Pillow**

## Kdy NEPOUŽÍVAT
- Generování fotografií, ikon, ilustrací → použij `kodi-image-generator`
- Komplexní grafika vyžadující AI generátor

---

## Vzor kódu

### Základní struktura
```python
#!/usr/bin/env python3
from PIL import Image, ImageDraw

# Rozměry
WIDTH, HEIGHT = 100, 100
RADIUS = 25

# Průhledné pozadí
img = Image.new('RGBA', (WIDTH, HEIGHT), (0, 0, 0, 0))
draw = ImageDraw.Draw(img)

# Kreslení tvaru (bílá výplň pro colordiffuse)
draw.rounded_rectangle(
    [(0, 0), (WIDTH - 1, HEIGHT - 1)],
    radius=RADIUS,
    fill=(255, 255, 255, 255)
)

# Uložení
img.save('output.png', 'PNG')
```

### Antialiasing (pro hladké hrany)
```python
SCALE = 4  # Upscale faktor
img = Image.new('RGBA', (WIDTH * SCALE, HEIGHT * SCALE), (0, 0, 0, 0))
# ... kresli ve vysokém rozlišení ...
img = img.resize((WIDTH, HEIGHT), Image.LANCZOS)  # Downscale
```

---

## Typy textur

| Typ | Popis | Radius |
|-----|-------|--------|
| Rounded rect | Zaoblený obdélník | `radius = 25` (nebo dle potřeby) |
| Pill | Plně zaoblené konce | `radius = HEIGHT // 2` |
| Circle | Kruh | `radius = WIDTH // 2` |

## Pravidla

1. **Vždy bílá výplň** `(255, 255, 255, 255)` - barvu nastaví Kodi přes `colordiffuse`
2. **Průhledné pozadí** `(0, 0, 0, 0)`
3. **Formát PNG** - zachová alpha channel
4. **Umístění skriptů** - `resources/media/generate_*.py`
5. **Výstup** - `resources/media/*.png`

## Běžné use cases

- `btn_rounded.png` - tlačítko se zaoblenými rohy
- `btn_pill.png` - pill-shaped tlačítko
- `scrollbar_rounded.png` - scrollbar s kulatými konci
- `card_mask.png` - maska pro oříznutí posterů
- `still_mask_rounded.png` - maska pro obrázky
