---
name: kodi-researcher
description: Research capability for Kodi/XBMC APIs. Use this to verify obscure behavior or find modern replacements for deprecated functions.
trigger: api_research, deprecated_functions, kodi_documentation, unknown_behavior
---

# Kodi Technical Researcher

## Search Strategy
When the user asks for help with a specific Kodi error or behavior, do not guess. Kodi documentation is fragmented.

### Source of Truth
* Doxygen (C++ API): The ultimate truth for how controls work.
* Kodi Wiki (Skinning Manual): Good for XML tags, check "History" for obsolescence.
* Forum (forum.kodi.tv): The best source for practical "how-to".

## Search Filters (Anti-Hallucination)
* Ignore Pre-2020 Python Code: Python 2 code (Kodi 18 and older) is incompatible with modern Kodi (Python 3).
    * Red Flags: `print "string"`, `xbmc.translatePath` (now `xbmcvfs.translatePath`).
* Verify Deprecations:
    * `ListItem.setInfo` params changed in Matrix (v19).
    * `iconImage` in `ListItem` constructor is deprecated.

## Browser Usage Queries
Use these query patterns in the integrated browser:
* `"xbmcgui WindowXML onInit vs init"`
* `"kodi skinning manual grouplist navigation"`
* `"python kodi addon crash log analysis"`
* `"site:github.com kodi-addon-dev example"`

## Context Injection
If you find a solution, summarize the logic (e.g., "The texture must be packed") rather than just pasting code snippets without context.